package org.wildfly.swarm.config.infinispan.cache_container.cache;

import org.wildfly.swarm.config.infinispan.cache_container.cache.PersistenceComponent;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PersistenceComponentConsumer<T extends PersistenceComponent<T>> {

	/**
	 * Configure a pre-constructed instance of PersistenceComponent resource
	 * 
	 * @parameter Instance of PersistenceComponent to configure
	 * @return nothing
	 */
	void accept(T value);

	default PersistenceComponentConsumer<T> andThen(
			PersistenceComponentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}