package org.wildfly.swarm.config.infinispan.cache_container.cache;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The cache transaction configuration.
 */
@Address("/subsystem=infinispan/cache-container=*/cache=*/component=transaction")
@ResourceType("component")
@Implicit
public class TransactionComponent<T extends TransactionComponent<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The number of transaction commits.")
	private Long commits;
	@AttributeDocumentation("The number of transaction prepares.")
	private Long prepares;
	@AttributeDocumentation("The number of transaction rollbacks.")
	private Long rollbacks;

	public TransactionComponent() {
		super();
		this.key = "transaction";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The number of transaction commits.
	 */
	@ModelNodeBinding(detypedName = "commits")
	public Long commits() {
		return this.commits;
	}

	/**
	 * The number of transaction commits.
	 */
	@SuppressWarnings("unchecked")
	public T commits(java.lang.Long value) {
		Object oldValue = this.commits;
		this.commits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("commits", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of transaction prepares.
	 */
	@ModelNodeBinding(detypedName = "prepares")
	public Long prepares() {
		return this.prepares;
	}

	/**
	 * The number of transaction prepares.
	 */
	@SuppressWarnings("unchecked")
	public T prepares(java.lang.Long value) {
		Object oldValue = this.prepares;
		this.prepares = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("prepares", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of transaction rollbacks.
	 */
	@ModelNodeBinding(detypedName = "rollbacks")
	public Long rollbacks() {
		return this.rollbacks;
	}

	/**
	 * The number of transaction rollbacks.
	 */
	@SuppressWarnings("unchecked")
	public T rollbacks(java.lang.Long value) {
		Object oldValue = this.rollbacks;
		this.rollbacks = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rollbacks", oldValue, value);
		return (T) this;
	}
}