package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.infinispan.remote_cache_container.ConnectionPoolComponent;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConnectionPoolComponentConsumer<T extends ConnectionPoolComponent<T>> {

	/**
	 * Configure a pre-constructed instance of ConnectionPoolComponent resource
	 * 
	 * @parameter Instance of ConnectionPoolComponent to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConnectionPoolComponentConsumer<T> andThen(
			ConnectionPoolComponentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}