package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configures using near cache in invalidated mode. When entries are updated or
 * removed server-side, invalidation messages will be sent to clients to remove
 * them from the near cache.
 */
@Address("/subsystem=infinispan/remote-cache-container=*/near-cache=invalidation")
@ResourceType("near-cache")
@Implicit
public class InvalidationNearCache<T extends InvalidationNearCache<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Defines the maximum number of elements to keep in the near cache.")
	private Integer maxEntries;

	public InvalidationNearCache() {
		super();
		this.key = "invalidation";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Defines the maximum number of elements to keep in the near cache.
	 */
	@ModelNodeBinding(detypedName = "max-entries")
	public Integer maxEntries() {
		return this.maxEntries;
	}

	/**
	 * Defines the maximum number of elements to keep in the near cache.
	 */
	@SuppressWarnings("unchecked")
	public T maxEntries(java.lang.Integer value) {
		Object oldValue = this.maxEntries;
		this.maxEntries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxEntries", oldValue, value);
		return (T) this;
	}
}