package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the infinispan subsystem.
 */
@Address("/subsystem=infinispan/remote-cache-container=*/remote-cache=*")
@ResourceType("remote-cache")
public class RemoteCache<T extends RemoteCache<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The average read time, in milliseconds, for this remote cache.")
	private Long averageReadTime;
	@AttributeDocumentation("The average remove time, in milliseconds, for this remote cache.")
	private Long averageRemoveTime;
	@AttributeDocumentation("The average write time, in milliseconds, to this remote cache.")
	private Long averageWriteTime;
	@AttributeDocumentation("The number of hits to this remote cache, excluding hits from the near-cache.")
	private Long hits;
	@AttributeDocumentation("The number of misses to this remote cache.")
	private Long misses;
	@AttributeDocumentation("The number of near-cache hits for this remote cache.")
	private Long nearCacheHits;
	@AttributeDocumentation("The number of near-cache invalidations for this remote cache.")
	private Long nearCacheInvalidations;
	@AttributeDocumentation("The number of near-cache misses for this remote cache.")
	private Long nearCacheMisses;
	@AttributeDocumentation("The number of entries in the near-cache for this remote cache.")
	private Long nearCacheSize;
	@AttributeDocumentation("The number of removes to this remote cache.")
	private Long removes;
	@AttributeDocumentation("The number of seconds since statistics were reset on this remote cache.")
	private Long timeSinceReset;
	@AttributeDocumentation("The number of writes to this remote cache.")
	private Long writes;

	public RemoteCache(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The average read time, in milliseconds, for this remote cache.
	 */
	@ModelNodeBinding(detypedName = "average-read-time")
	public Long averageReadTime() {
		return this.averageReadTime;
	}

	/**
	 * The average read time, in milliseconds, for this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T averageReadTime(java.lang.Long value) {
		Object oldValue = this.averageReadTime;
		this.averageReadTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageReadTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The average remove time, in milliseconds, for this remote cache.
	 */
	@ModelNodeBinding(detypedName = "average-remove-time")
	public Long averageRemoveTime() {
		return this.averageRemoveTime;
	}

	/**
	 * The average remove time, in milliseconds, for this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T averageRemoveTime(java.lang.Long value) {
		Object oldValue = this.averageRemoveTime;
		this.averageRemoveTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageRemoveTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The average write time, in milliseconds, to this remote cache.
	 */
	@ModelNodeBinding(detypedName = "average-write-time")
	public Long averageWriteTime() {
		return this.averageWriteTime;
	}

	/**
	 * The average write time, in milliseconds, to this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T averageWriteTime(java.lang.Long value) {
		Object oldValue = this.averageWriteTime;
		this.averageWriteTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageWriteTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of hits to this remote cache, excluding hits from the
	 * near-cache.
	 */
	@ModelNodeBinding(detypedName = "hits")
	public Long hits() {
		return this.hits;
	}

	/**
	 * The number of hits to this remote cache, excluding hits from the
	 * near-cache.
	 */
	@SuppressWarnings("unchecked")
	public T hits(java.lang.Long value) {
		Object oldValue = this.hits;
		this.hits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hits", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of misses to this remote cache.
	 */
	@ModelNodeBinding(detypedName = "misses")
	public Long misses() {
		return this.misses;
	}

	/**
	 * The number of misses to this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T misses(java.lang.Long value) {
		Object oldValue = this.misses;
		this.misses = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("misses", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of near-cache hits for this remote cache.
	 */
	@ModelNodeBinding(detypedName = "near-cache-hits")
	public Long nearCacheHits() {
		return this.nearCacheHits;
	}

	/**
	 * The number of near-cache hits for this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T nearCacheHits(java.lang.Long value) {
		Object oldValue = this.nearCacheHits;
		this.nearCacheHits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nearCacheHits", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of near-cache invalidations for this remote cache.
	 */
	@ModelNodeBinding(detypedName = "near-cache-invalidations")
	public Long nearCacheInvalidations() {
		return this.nearCacheInvalidations;
	}

	/**
	 * The number of near-cache invalidations for this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T nearCacheInvalidations(java.lang.Long value) {
		Object oldValue = this.nearCacheInvalidations;
		this.nearCacheInvalidations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nearCacheInvalidations", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of near-cache misses for this remote cache.
	 */
	@ModelNodeBinding(detypedName = "near-cache-misses")
	public Long nearCacheMisses() {
		return this.nearCacheMisses;
	}

	/**
	 * The number of near-cache misses for this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T nearCacheMisses(java.lang.Long value) {
		Object oldValue = this.nearCacheMisses;
		this.nearCacheMisses = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nearCacheMisses", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of entries in the near-cache for this remote cache.
	 */
	@ModelNodeBinding(detypedName = "near-cache-size")
	public Long nearCacheSize() {
		return this.nearCacheSize;
	}

	/**
	 * The number of entries in the near-cache for this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T nearCacheSize(java.lang.Long value) {
		Object oldValue = this.nearCacheSize;
		this.nearCacheSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nearCacheSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of removes to this remote cache.
	 */
	@ModelNodeBinding(detypedName = "removes")
	public Long removes() {
		return this.removes;
	}

	/**
	 * The number of removes to this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T removes(java.lang.Long value) {
		Object oldValue = this.removes;
		this.removes = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("removes", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of seconds since statistics were reset on this remote cache.
	 */
	@ModelNodeBinding(detypedName = "time-since-reset")
	public Long timeSinceReset() {
		return this.timeSinceReset;
	}

	/**
	 * The number of seconds since statistics were reset on this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T timeSinceReset(java.lang.Long value) {
		Object oldValue = this.timeSinceReset;
		this.timeSinceReset = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timeSinceReset", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of writes to this remote cache.
	 */
	@ModelNodeBinding(detypedName = "writes")
	public Long writes() {
		return this.writes;
	}

	/**
	 * The number of writes to this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T writes(java.lang.Long value) {
		Object oldValue = this.writes;
		this.writes = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("writes", oldValue, value);
		return (T) this;
	}
}