package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCache;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RemoteCacheConsumer<T extends RemoteCache<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteCache resource
	 * 
	 * @parameter Instance of RemoteCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteCacheConsumer<T> andThen(RemoteCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}