package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Configuration of a remote cluster.
 */
@Address("/subsystem=infinispan/remote-cache-container=*/remote-cluster=*")
@ResourceType("remote-cluster")
public class RemoteCluster<T extends RemoteCluster<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("List of outbound-socket-bindings of Hot Rod servers to connect to.")
	private List<String> socketBindings;

	public RemoteCluster(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * List of outbound-socket-bindings of Hot Rod servers to connect to.
	 */
	@ModelNodeBinding(detypedName = "socket-bindings")
	public List<String> socketBindings() {
		return this.socketBindings;
	}

	/**
	 * List of outbound-socket-bindings of Hot Rod servers to connect to.
	 */
	@SuppressWarnings("unchecked")
	public T socketBindings(java.util.List<String> value) {
		Object oldValue = this.socketBindings;
		this.socketBindings = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBindings", oldValue, value);
		return (T) this;
	}

	/**
	 * List of outbound-socket-bindings of Hot Rod servers to connect to.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		if (this.socketBindings == null) {
			this.socketBindings = new java.util.ArrayList<>();
		}
		this.socketBindings.add(value);
		return (T) this;
	}

	/**
	 * List of outbound-socket-bindings of Hot Rod servers to connect to.
	 */
	@SuppressWarnings("unchecked")
	public T socketBindings(String... args) {
		socketBindings(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}