package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCluster;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RemoteClusterConsumer<T extends RemoteCluster<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteCluster resource
	 * 
	 * @parameter Instance of RemoteCluster to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteClusterConsumer<T> andThen(RemoteClusterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}