package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.infinispan.remote_cache_container.SecurityComponent;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SecurityComponentConsumer<T extends SecurityComponent<T>> {

	/**
	 * Configure a pre-constructed instance of SecurityComponent resource
	 * 
	 * @parameter Instance of SecurityComponent to configure
	 * @return nothing
	 */
	void accept(T value);

	default SecurityComponentConsumer<T> andThen(
			SecurityComponentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}