package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * The cache transaction configuration.
 */
@Address("/subsystem=infinispan/remote-cache-container=*/component=transaction")
@ResourceType("component")
@Implicit
public class TransactionComponent<T extends TransactionComponent<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Sets the cache transaction mode to one of NONE, NON_XA, NON_DURABLE_XA, FULL_XA.")
	private Mode mode;
	@AttributeDocumentation("The duration (in ms) after which idle transactions are rolled back.")
	private Long timeout;

	public TransactionComponent() {
		super();
		this.key = "transaction";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Mode {
		NONE("NONE"), BATCH("BATCH"), NON_DURABLE_XA("NON_DURABLE_XA");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Mode(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Sets the cache transaction mode to one of NONE, NON_XA, NON_DURABLE_XA,
	 * FULL_XA.
	 */
	@ModelNodeBinding(detypedName = "mode")
	public Mode mode() {
		return this.mode;
	}

	/**
	 * Sets the cache transaction mode to one of NONE, NON_XA, NON_DURABLE_XA,
	 * FULL_XA.
	 */
	@SuppressWarnings("unchecked")
	public T mode(Mode value) {
		Object oldValue = this.mode;
		this.mode = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mode", oldValue, value);
		return (T) this;
	}

	/**
	 * The duration (in ms) after which idle transactions are rolled back.
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Long timeout() {
		return this.timeout;
	}

	/**
	 * The duration (in ms) after which idle transactions are rolled back.
	 */
	@SuppressWarnings("unchecked")
	public T timeout(java.lang.Long value) {
		Object oldValue = this.timeout;
		this.timeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timeout", oldValue, value);
		return (T) this;
	}
}