package org.wildfly.swarm.config.io;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.io.worker.ServerConsumer;
import org.wildfly.swarm.config.io.worker.ServerSupplier;
import org.wildfly.swarm.config.io.worker.Server;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.io.worker.OutboundBindAddressConsumer;
import org.wildfly.swarm.config.io.worker.OutboundBindAddressSupplier;
import org.wildfly.swarm.config.io.worker.OutboundBindAddress;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Defines workers
 */
@Address("/subsystem=io/worker=*")
@ResourceType("worker")
public class Worker<T extends Worker<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private WorkerResources subresources = new WorkerResources();
	@AttributeDocumentation("An estimate of busy threads in the task worker thread pool")
	private Integer busyTaskThreadCount;
	@AttributeDocumentation("Minimum number of threads to keep in the underlying thread pool even if they are idle. Threads over this limit will be terminated over time specified by task-keepalive attribute.")
	private Integer corePoolSize;
	@AttributeDocumentation("I/O thread count")
	private Integer ioThreadCount;
	@AttributeDocumentation("Specify the number of I/O threads to create for the worker.  If not specified, a default will be chosen, which is calculated by cpuCount * 2")
	private Integer ioThreads;
	@AttributeDocumentation("The maximum number of threads to allow in the thread pool. Depending on implementation, when this limit is reached, tasks which cannot be queued may be rejected.")
	private Integer maxPoolSize;
	@AttributeDocumentation("An estimate of the number of tasks in the worker queue.")
	private Integer queueSize;
	@AttributeDocumentation("True is shutdown of the pool was requested")
	private Boolean shutdownRequested;
	@AttributeDocumentation("The stack size (in bytes) to attempt to use for worker threads.")
	private Long stackSize;
	@AttributeDocumentation("Specify the starting number of threads for the worker task thread pool.")
	private Integer taskCoreThreads;
	@AttributeDocumentation("Specify the number of milliseconds to keep non-core task threads alive.")
	private Integer taskKeepalive;
	@AttributeDocumentation("Specify the maximum number of threads for the worker task thread pool.If not set, default value used which is calculated by formula cpuCount * 16,as long as MaxFileDescriptorCount jmx property allows that number, otherwise calculation takes max into account to adjust it accordingly.")
	private Integer taskMaxThreads;

	public Worker(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public WorkerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Server objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Server objects.
	 */
	@SuppressWarnings("unchecked")
	public T servers(java.util.List<Server> value) {
		this.subresources.servers = value;
		return (T) this;
	}

	/**
	 * Add the Server object to the list of subresources
	 * 
	 * @param value
	 *            The Server to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(Server value) {
		this.subresources.servers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Server object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Server resource
	 * @param config
	 *            The ServerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(java.lang.String childKey, ServerConsumer consumer) {
		Server<? extends Server> child = new Server<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		server(child);
		return (T) this;
	}

	/**
	 * Create and configure a Server object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Server resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(java.lang.String childKey) {
		server(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Server object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T server(ServerSupplier supplier) {
		server(supplier.get());
		return (T) this;
	}

	/**
	 * Add all OutboundBindAddress objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of OutboundBindAddress objects.
	 */
	@SuppressWarnings("unchecked")
	public T outboundBindAddress(java.util.List<OutboundBindAddress> value) {
		this.subresources.outboundBindAddress = value;
		return (T) this;
	}

	/**
	 * Add the OutboundBindAddress object to the list of subresources
	 * 
	 * @param value
	 *            The OutboundBindAddress to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundBindAddress(OutboundBindAddress value) {
		this.subresources.outboundBindAddress.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a OutboundBindAddress object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the OutboundBindAddress resource
	 * @param config
	 *            The OutboundBindAddressConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundBindAddress(java.lang.String childKey,
			OutboundBindAddressConsumer consumer) {
		OutboundBindAddress<? extends OutboundBindAddress> child = new OutboundBindAddress<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		outboundBindAddress(child);
		return (T) this;
	}

	/**
	 * Create and configure a OutboundBindAddress object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the OutboundBindAddress resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundBindAddress(java.lang.String childKey) {
		outboundBindAddress(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied OutboundBindAddress object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T outboundBindAddress(OutboundBindAddressSupplier supplier) {
		outboundBindAddress(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Worker
	 */
	public static class WorkerResources {
		/**
		 * Runtime resource that describes listening servers utilizing this
		 * worker
		 */
		@ResourceDocumentation("Runtime resource that describes listening servers utilizing this worker")
		@SubresourceInfo("server")
		private List<Server> servers = new java.util.ArrayList<>();
		/**
		 * Defines a bind address to use when connecting to the specified
		 * destination
		 */
		@ResourceDocumentation("Defines a bind address to use when connecting to the specified destination")
		@SubresourceInfo("outboundBindAddress")
		private List<OutboundBindAddress> outboundBindAddress = new java.util.ArrayList<>();

		/**
		 * Get the list of Server resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Server> servers() {
			return this.servers;
		}

		public Server server(java.lang.String key) {
			return this.servers.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of OutboundBindAddress resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<OutboundBindAddress> outboundBindAddress() {
			return this.outboundBindAddress;
		}

		public OutboundBindAddress outboundBindAddress(java.lang.String key) {
			return this.outboundBindAddress.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * An estimate of busy threads in the task worker thread pool
	 */
	@ModelNodeBinding(detypedName = "busy-task-thread-count")
	public Integer busyTaskThreadCount() {
		return this.busyTaskThreadCount;
	}

	/**
	 * An estimate of busy threads in the task worker thread pool
	 */
	@SuppressWarnings("unchecked")
	public T busyTaskThreadCount(java.lang.Integer value) {
		Object oldValue = this.busyTaskThreadCount;
		this.busyTaskThreadCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("busyTaskThreadCount", oldValue, value);
		return (T) this;
	}

	/**
	 * Minimum number of threads to keep in the underlying thread pool even if
	 * they are idle. Threads over this limit will be terminated over time
	 * specified by task-keepalive attribute.
	 */
	@ModelNodeBinding(detypedName = "core-pool-size")
	public Integer corePoolSize() {
		return this.corePoolSize;
	}

	/**
	 * Minimum number of threads to keep in the underlying thread pool even if
	 * they are idle. Threads over this limit will be terminated over time
	 * specified by task-keepalive attribute.
	 */
	@SuppressWarnings("unchecked")
	public T corePoolSize(java.lang.Integer value) {
		Object oldValue = this.corePoolSize;
		this.corePoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("corePoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * I/O thread count
	 */
	@ModelNodeBinding(detypedName = "io-thread-count")
	public Integer ioThreadCount() {
		return this.ioThreadCount;
	}

	/**
	 * I/O thread count
	 */
	@SuppressWarnings("unchecked")
	public T ioThreadCount(java.lang.Integer value) {
		Object oldValue = this.ioThreadCount;
		this.ioThreadCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ioThreadCount", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify the number of I/O threads to create for the worker. If not
	 * specified, a default will be chosen, which is calculated by cpuCount * 2
	 */
	@ModelNodeBinding(detypedName = "io-threads")
	public Integer ioThreads() {
		return this.ioThreads;
	}

	/**
	 * Specify the number of I/O threads to create for the worker. If not
	 * specified, a default will be chosen, which is calculated by cpuCount * 2
	 */
	@SuppressWarnings("unchecked")
	public T ioThreads(java.lang.Integer value) {
		Object oldValue = this.ioThreads;
		this.ioThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ioThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of threads to allow in the thread pool. Depending on
	 * implementation, when this limit is reached, tasks which cannot be queued
	 * may be rejected.
	 */
	@ModelNodeBinding(detypedName = "max-pool-size")
	public Integer maxPoolSize() {
		return this.maxPoolSize;
	}

	/**
	 * The maximum number of threads to allow in the thread pool. Depending on
	 * implementation, when this limit is reached, tasks which cannot be queued
	 * may be rejected.
	 */
	@SuppressWarnings("unchecked")
	public T maxPoolSize(java.lang.Integer value) {
		Object oldValue = this.maxPoolSize;
		this.maxPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * An estimate of the number of tasks in the worker queue.
	 */
	@ModelNodeBinding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * An estimate of the number of tasks in the worker queue.
	 */
	@SuppressWarnings("unchecked")
	public T queueSize(java.lang.Integer value) {
		Object oldValue = this.queueSize;
		this.queueSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueSize", oldValue, value);
		return (T) this;
	}

	/**
	 * True is shutdown of the pool was requested
	 */
	@ModelNodeBinding(detypedName = "shutdown-requested")
	public Boolean shutdownRequested() {
		return this.shutdownRequested;
	}

	/**
	 * True is shutdown of the pool was requested
	 */
	@SuppressWarnings("unchecked")
	public T shutdownRequested(java.lang.Boolean value) {
		Object oldValue = this.shutdownRequested;
		this.shutdownRequested = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("shutdownRequested", oldValue, value);
		return (T) this;
	}

	/**
	 * The stack size (in bytes) to attempt to use for worker threads.
	 */
	@ModelNodeBinding(detypedName = "stack-size")
	public Long stackSize() {
		return this.stackSize;
	}

	/**
	 * The stack size (in bytes) to attempt to use for worker threads.
	 */
	@SuppressWarnings("unchecked")
	public T stackSize(java.lang.Long value) {
		Object oldValue = this.stackSize;
		this.stackSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stackSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify the starting number of threads for the worker task thread pool.
	 */
	@ModelNodeBinding(detypedName = "task-core-threads")
	public Integer taskCoreThreads() {
		return this.taskCoreThreads;
	}

	/**
	 * Specify the starting number of threads for the worker task thread pool.
	 */
	@SuppressWarnings("unchecked")
	public T taskCoreThreads(java.lang.Integer value) {
		Object oldValue = this.taskCoreThreads;
		this.taskCoreThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("taskCoreThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify the number of milliseconds to keep non-core task threads alive.
	 */
	@ModelNodeBinding(detypedName = "task-keepalive")
	public Integer taskKeepalive() {
		return this.taskKeepalive;
	}

	/**
	 * Specify the number of milliseconds to keep non-core task threads alive.
	 */
	@SuppressWarnings("unchecked")
	public T taskKeepalive(java.lang.Integer value) {
		Object oldValue = this.taskKeepalive;
		this.taskKeepalive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("taskKeepalive", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify the maximum number of threads for the worker task thread pool.If
	 * not set, default value used which is calculated by formula cpuCount *
	 * 16,as long as MaxFileDescriptorCount jmx property allows that number,
	 * otherwise calculation takes max into account to adjust it accordingly.
	 */
	@ModelNodeBinding(detypedName = "task-max-threads")
	public Integer taskMaxThreads() {
		return this.taskMaxThreads;
	}

	/**
	 * Specify the maximum number of threads for the worker task thread pool.If
	 * not set, default value used which is calculated by formula cpuCount *
	 * 16,as long as MaxFileDescriptorCount jmx property allows that number,
	 * otherwise calculation takes max into account to adjust it accordingly.
	 */
	@SuppressWarnings("unchecked")
	public T taskMaxThreads(java.lang.Integer value) {
		Object oldValue = this.taskMaxThreads;
		this.taskMaxThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("taskMaxThreads", oldValue, value);
		return (T) this;
	}
}