package org.wildfly.swarm.config.io.worker;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Defines a bind address to use when connecting to the specified destination
 */
@Address("/subsystem=io/worker=*/outbound-bind-address=*")
@ResourceType("outbound-bind-address")
public class OutboundBindAddress<T extends OutboundBindAddress<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The address to bind to when the destination address matches")
	private String bindAddress;
	@AttributeDocumentation("The port number to bind to when the destination address matches")
	private Integer bindPort;
	@AttributeDocumentation("The destination address range to match")
	private String match;

	public OutboundBindAddress(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The address to bind to when the destination address matches
	 */
	@ModelNodeBinding(detypedName = "bind-address")
	public String bindAddress() {
		return this.bindAddress;
	}

	/**
	 * The address to bind to when the destination address matches
	 */
	@SuppressWarnings("unchecked")
	public T bindAddress(java.lang.String value) {
		Object oldValue = this.bindAddress;
		this.bindAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bindAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * The port number to bind to when the destination address matches
	 */
	@ModelNodeBinding(detypedName = "bind-port")
	public Integer bindPort() {
		return this.bindPort;
	}

	/**
	 * The port number to bind to when the destination address matches
	 */
	@SuppressWarnings("unchecked")
	public T bindPort(java.lang.Integer value) {
		Object oldValue = this.bindPort;
		this.bindPort = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bindPort", oldValue, value);
		return (T) this;
	}

	/**
	 * The destination address range to match
	 */
	@ModelNodeBinding(detypedName = "match")
	public String match() {
		return this.match;
	}

	/**
	 * The destination address range to match
	 */
	@SuppressWarnings("unchecked")
	public T match(java.lang.String value) {
		Object oldValue = this.match;
		this.match = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("match", oldValue, value);
		return (T) this;
	}
}