package org.wildfly.swarm.config.jgroups.stack;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.jgroups.PropertyConsumer;
import org.wildfly.swarm.config.jgroups.PropertySupplier;
import org.wildfly.swarm.config.jgroups.Property;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.jgroups.stack.transport.OobThreadPool;
import org.wildfly.swarm.config.jgroups.stack.transport.OobThreadPoolConsumer;
import org.wildfly.swarm.config.jgroups.stack.transport.OobThreadPoolSupplier;
import org.wildfly.swarm.config.jgroups.stack.transport.InternalThreadPool;
import org.wildfly.swarm.config.jgroups.stack.transport.InternalThreadPoolConsumer;
import org.wildfly.swarm.config.jgroups.stack.transport.InternalThreadPoolSupplier;
import org.wildfly.swarm.config.jgroups.stack.transport.DefaultThreadPool;
import org.wildfly.swarm.config.jgroups.stack.transport.DefaultThreadPoolConsumer;
import org.wildfly.swarm.config.jgroups.stack.transport.DefaultThreadPoolSupplier;
import org.wildfly.swarm.config.jgroups.stack.transport.TimerThreadPool;
import org.wildfly.swarm.config.jgroups.stack.transport.TimerThreadPoolConsumer;
import org.wildfly.swarm.config.jgroups.stack.transport.TimerThreadPoolSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * The configuration of a transport for a protocol stack.
 */
@Address("/subsystem=jgroups/stack=*/transport=*")
@ResourceType("transport")
public class Transport<T extends Transport<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private TransportResources subresources = new TransportResources();
	@AttributeDocumentation("The thread pool executor to handle incoming messages.")
	private String defaultExecutor;
	@AttributeDocumentation("The diagnostics socket binding specification for this protocol layer, used to specify IP interfaces and ports for communication.")
	private String diagnosticsSocketBinding;
	@AttributeDocumentation("The machine (i.e. host) identifier for this node. Used by Infinispan topology-aware consistent hash.")
	private String machine;
	@AttributeDocumentation("The module with which to resolve the protocol type.")
	private String module;
	@AttributeDocumentation("The thread pool executor to handle incoming out-of-band messages.")
	private String oobExecutor;
	@AttributeDocumentation("The properties of this protocol.")
	private Map properties;
	@AttributeDocumentation("The rack (i.e. server rack) identifier for this node. Used by Infinispan topology-aware consistent hash.")
	private String rack;
	@AttributeDocumentation("If true, the underlying transport is shared by all channels using this stack.")
	private Boolean shared;
	@AttributeDocumentation("The site (i.e. data centre) identifier for this node. Used by Infinispan topology-aware consistent hash.")
	private String site;
	@AttributeDocumentation("Defines the bind address/port used of the server socket used to receive messages from other cluster members.")
	private String socketBinding;
	@AttributeDocumentation("Indicates whether or not this protocol will collect statistics overriding stack configuration.")
	private Boolean statisticsEnabled;
	@AttributeDocumentation("The thread factory to use for handling asynchronous transport-specific tasks.")
	private String threadFactory;
	@AttributeDocumentation("The thread pool executor to handle protocol-related timing tasks.")
	private String timerExecutor;

	public Transport(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public TransportResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Property objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.List<Property> value) {
		this.subresources.properties = value;
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * 
	 * @param value
	 *            The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.properties.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Property object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Property resource
	 * @param config
	 *            The PropertyConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String childKey, PropertyConsumer consumer) {
		Property<? extends Property> child = new Property<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		property(child);
		return (T) this;
	}

	/**
	 * Create and configure a Property object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Property resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String childKey) {
		property(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Property object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T property(PropertySupplier supplier) {
		property(supplier.get());
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T oobThreadPool(OobThreadPool value) {
		this.subresources.oobThreadPool = value;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T oobThreadPool(OobThreadPoolConsumer consumer) {
		OobThreadPool<? extends OobThreadPool> child = new OobThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.oobThreadPool = child;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T oobThreadPool() {
		OobThreadPool<? extends OobThreadPool> child = new OobThreadPool<>();
		this.subresources.oobThreadPool = child;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T oobThreadPool(OobThreadPoolSupplier supplier) {
		this.subresources.oobThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T internalThreadPool(InternalThreadPool value) {
		this.subresources.internalThreadPool = value;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T internalThreadPool(InternalThreadPoolConsumer consumer) {
		InternalThreadPool<? extends InternalThreadPool> child = new InternalThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.internalThreadPool = child;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T internalThreadPool() {
		InternalThreadPool<? extends InternalThreadPool> child = new InternalThreadPool<>();
		this.subresources.internalThreadPool = child;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T internalThreadPool(InternalThreadPoolSupplier supplier) {
		this.subresources.internalThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T defaultThreadPool(DefaultThreadPool value) {
		this.subresources.defaultThreadPool = value;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T defaultThreadPool(DefaultThreadPoolConsumer consumer) {
		DefaultThreadPool<? extends DefaultThreadPool> child = new DefaultThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.defaultThreadPool = child;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T defaultThreadPool() {
		DefaultThreadPool<? extends DefaultThreadPool> child = new DefaultThreadPool<>();
		this.subresources.defaultThreadPool = child;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T defaultThreadPool(DefaultThreadPoolSupplier supplier) {
		this.subresources.defaultThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T timerThreadPool(TimerThreadPool value) {
		this.subresources.timerThreadPool = value;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T timerThreadPool(TimerThreadPoolConsumer consumer) {
		TimerThreadPool<? extends TimerThreadPool> child = new TimerThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.timerThreadPool = child;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T timerThreadPool() {
		TimerThreadPool<? extends TimerThreadPool> child = new TimerThreadPool<>();
		this.subresources.timerThreadPool = child;
		return (T) this;
	}

	/**
	 * A thread pool executor
	 */
	@SuppressWarnings("unchecked")
	public T timerThreadPool(TimerThreadPoolSupplier supplier) {
		this.subresources.timerThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Transport
	 */
	public static class TransportResources {
		/**
		 * A protocol property with name and value.
		 */
		@ResourceDocumentation("A protocol property with name and value.")
		@SubresourceInfo("property")
		private List<Property> properties = new java.util.ArrayList<>();
		@SingletonResource
		@ResourceDocumentation("A thread pool executor")
		private OobThreadPool oobThreadPool;
		@SingletonResource
		@ResourceDocumentation("A thread pool executor")
		private InternalThreadPool internalThreadPool;
		@SingletonResource
		@ResourceDocumentation("A thread pool executor")
		private DefaultThreadPool defaultThreadPool;
		@SingletonResource
		@ResourceDocumentation("A thread pool executor")
		private TimerThreadPool timerThreadPool;

		/**
		 * Get the list of Property resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> properties() {
			return this.properties;
		}

		public Property property(java.lang.String key) {
			return this.properties.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * A thread pool executor
		 */
		@Subresource
		public OobThreadPool oobThreadPool() {
			return this.oobThreadPool;
		}

		/**
		 * A thread pool executor
		 */
		@Subresource
		public InternalThreadPool internalThreadPool() {
			return this.internalThreadPool;
		}

		/**
		 * A thread pool executor
		 */
		@Subresource
		public DefaultThreadPool defaultThreadPool() {
			return this.defaultThreadPool;
		}

		/**
		 * A thread pool executor
		 */
		@Subresource
		public TimerThreadPool timerThreadPool() {
			return this.timerThreadPool;
		}
	}

	/**
	 * The thread pool executor to handle incoming messages.
	 * 
	 * @deprecated Deprecated. Supports EAP 6.x slaves.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "default-executor")
	public String defaultExecutor() {
		return this.defaultExecutor;
	}

	/**
	 * The thread pool executor to handle incoming messages.
	 * 
	 * @deprecated Deprecated. Supports EAP 6.x slaves.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T defaultExecutor(java.lang.String value) {
		Object oldValue = this.defaultExecutor;
		this.defaultExecutor = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultExecutor", oldValue, value);
		return (T) this;
	}

	/**
	 * The diagnostics socket binding specification for this protocol layer,
	 * used to specify IP interfaces and ports for communication.
	 */
	@ModelNodeBinding(detypedName = "diagnostics-socket-binding")
	public String diagnosticsSocketBinding() {
		return this.diagnosticsSocketBinding;
	}

	/**
	 * The diagnostics socket binding specification for this protocol layer,
	 * used to specify IP interfaces and ports for communication.
	 */
	@SuppressWarnings("unchecked")
	public T diagnosticsSocketBinding(java.lang.String value) {
		Object oldValue = this.diagnosticsSocketBinding;
		this.diagnosticsSocketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("diagnosticsSocketBinding", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The machine (i.e. host) identifier for this node. Used by Infinispan
	 * topology-aware consistent hash.
	 */
	@ModelNodeBinding(detypedName = "machine")
	public String machine() {
		return this.machine;
	}

	/**
	 * The machine (i.e. host) identifier for this node. Used by Infinispan
	 * topology-aware consistent hash.
	 */
	@SuppressWarnings("unchecked")
	public T machine(java.lang.String value) {
		Object oldValue = this.machine;
		this.machine = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("machine", oldValue, value);
		return (T) this;
	}

	/**
	 * The module with which to resolve the protocol type.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module with which to resolve the protocol type.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * The thread pool executor to handle incoming out-of-band messages.
	 * 
	 * @deprecated Deprecated. Supports EAP 6.x slaves.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "oob-executor")
	public String oobExecutor() {
		return this.oobExecutor;
	}

	/**
	 * The thread pool executor to handle incoming out-of-band messages.
	 * 
	 * @deprecated Deprecated. Supports EAP 6.x slaves.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T oobExecutor(java.lang.String value) {
		Object oldValue = this.oobExecutor;
		this.oobExecutor = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("oobExecutor", oldValue, value);
		return (T) this;
	}

	/**
	 * The properties of this protocol.
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * The properties of this protocol.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.Map value) {
		Object oldValue = this.properties;
		this.properties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("properties", oldValue, value);
		return (T) this;
	}

	/**
	 * The properties of this protocol.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.properties == null) {
			this.properties = new java.util.HashMap<>();
		}
		this.properties.put(key, value);
		return (T) this;
	}

	/**
	 * The rack (i.e. server rack) identifier for this node. Used by Infinispan
	 * topology-aware consistent hash.
	 */
	@ModelNodeBinding(detypedName = "rack")
	public String rack() {
		return this.rack;
	}

	/**
	 * The rack (i.e. server rack) identifier for this node. Used by Infinispan
	 * topology-aware consistent hash.
	 */
	@SuppressWarnings("unchecked")
	public T rack(java.lang.String value) {
		Object oldValue = this.rack;
		this.rack = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rack", oldValue, value);
		return (T) this;
	}

	/**
	 * If true, the underlying transport is shared by all channels using this
	 * stack.
	 * 
	 * @deprecated Deprecated. Transport sharing is now achieved by using fork
	 *             channels.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "shared")
	public Boolean shared() {
		return this.shared;
	}

	/**
	 * If true, the underlying transport is shared by all channels using this
	 * stack.
	 * 
	 * @deprecated Deprecated. Transport sharing is now achieved by using fork
	 *             channels.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T shared(java.lang.Boolean value) {
		Object oldValue = this.shared;
		this.shared = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("shared", oldValue, value);
		return (T) this;
	}

	/**
	 * The site (i.e. data centre) identifier for this node. Used by Infinispan
	 * topology-aware consistent hash.
	 */
	@ModelNodeBinding(detypedName = "site")
	public String site() {
		return this.site;
	}

	/**
	 * The site (i.e. data centre) identifier for this node. Used by Infinispan
	 * topology-aware consistent hash.
	 */
	@SuppressWarnings("unchecked")
	public T site(java.lang.String value) {
		Object oldValue = this.site;
		this.site = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("site", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the bind address/port used of the server socket used to receive
	 * messages from other cluster members.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * Defines the bind address/port used of the server socket used to receive
	 * messages from other cluster members.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether or not this protocol will collect statistics overriding
	 * stack configuration.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Indicates whether or not this protocol will collect statistics overriding
	 * stack configuration.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(java.lang.Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The thread factory to use for handling asynchronous transport-specific
	 * tasks.
	 * 
	 * @deprecated Deprecated. Supports EAP 6.x slaves.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "thread-factory")
	public String threadFactory() {
		return this.threadFactory;
	}

	/**
	 * The thread factory to use for handling asynchronous transport-specific
	 * tasks.
	 * 
	 * @deprecated Deprecated. Supports EAP 6.x slaves.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T threadFactory(java.lang.String value) {
		Object oldValue = this.threadFactory;
		this.threadFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadFactory", oldValue, value);
		return (T) this;
	}

	/**
	 * The thread pool executor to handle protocol-related timing tasks.
	 * 
	 * @deprecated Deprecated. Supports EAP 6.x slaves.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "timer-executor")
	public String timerExecutor() {
		return this.timerExecutor;
	}

	/**
	 * The thread pool executor to handle protocol-related timing tasks.
	 * 
	 * @deprecated Deprecated. Supports EAP 6.x slaves.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T timerExecutor(java.lang.String value) {
		Object oldValue = this.timerExecutor;
		this.timerExecutor = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timerExecutor", oldValue, value);
		return (T) this;
	}
}