package org.wildfly.swarm.config.jgroups.stack.relay;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A remote site to which to bridge.
 */
@Address("/subsystem=jgroups/stack=*/relay=relay.RELAY2/remote-site=*")
@ResourceType("remote-site")
public class RemoteSite<T extends RemoteSite<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the bridge channel used to communicate with this remote site.")
	private String channel;
	@AttributeDocumentation("The cluster name of the bridge channel to this remote site.")
	private String cluster;
	@AttributeDocumentation("The stack from which to create a bridge to this remote site.")
	private String stack;

	public RemoteSite(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the bridge channel used to communicate with this remote site.
	 */
	@ModelNodeBinding(detypedName = "channel")
	public String channel() {
		return this.channel;
	}

	/**
	 * The name of the bridge channel used to communicate with this remote site.
	 */
	@SuppressWarnings("unchecked")
	public T channel(java.lang.String value) {
		Object oldValue = this.channel;
		this.channel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("channel", oldValue, value);
		return (T) this;
	}

	/**
	 * The cluster name of the bridge channel to this remote site.
	 * 
	 * @deprecated Deprecated. Use an explicitly defined channel instead.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "cluster")
	public String cluster() {
		return this.cluster;
	}

	/**
	 * The cluster name of the bridge channel to this remote site.
	 * 
	 * @deprecated Deprecated. Use an explicitly defined channel instead.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T cluster(java.lang.String value) {
		Object oldValue = this.cluster;
		this.cluster = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cluster", oldValue, value);
		return (T) this;
	}

	/**
	 * The stack from which to create a bridge to this remote site.
	 * 
	 * @deprecated Deprecated. Use an explicitly defined channel instead.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "stack")
	public String stack() {
		return this.stack;
	}

	/**
	 * The stack from which to create a bridge to this remote site.
	 * 
	 * @deprecated Deprecated. Use an explicitly defined channel instead.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T stack(java.lang.String value) {
		Object oldValue = this.stack;
		this.stack = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stack", oldValue, value);
		return (T) this;
	}
}