package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;
import org.wildfly.swarm.config.logging.Level;

/**
 * Defines a handler which writes to a file.
 */
@Address("/subsystem=logging/file-handler=*")
@ResourceType("file-handler")
public class FileHandler<T extends FileHandler<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Specify whether to append to the target file.")
	private Boolean append;
	@AttributeDocumentation("Automatically flush after each write.")
	private Boolean autoflush;
	@AttributeDocumentation("If set to true the handler is enabled and functioning as normal, if set to false the handler is ignored when processing log messages.")
	private Boolean enabled;
	@AttributeDocumentation("The character encoding used by this Handler.")
	private String encoding;
	@AttributeDocumentation("The file description consisting of the path and optional relative to path.")
	private Map file;
	@AttributeDocumentation("Defines a simple filter type.")
	private Map filter;
	@AttributeDocumentation("A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match(\"JBAS.*\"))")
	private String filterSpec;
	@AttributeDocumentation("Defines a pattern for the formatter.")
	private String formatter;
	@AttributeDocumentation("The log level specifying which message levels will be logged by this logger. Message levels lower than this value will be discarded.")
	private Level level;
	@AttributeDocumentation("The name of the handler.")
	private String name;
	@AttributeDocumentation("The name of the defined formatter to be used on the handler.")
	private String namedFormatter;

	public FileHandler(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Specify whether to append to the target file.
	 */
	@ModelNodeBinding(detypedName = "append")
	public Boolean append() {
		return this.append;
	}

	/**
	 * Specify whether to append to the target file.
	 */
	@SuppressWarnings("unchecked")
	public T append(java.lang.Boolean value) {
		Object oldValue = this.append;
		this.append = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("append", oldValue, value);
		return (T) this;
	}

	/**
	 * Automatically flush after each write.
	 */
	@ModelNodeBinding(detypedName = "autoflush")
	public Boolean autoflush() {
		return this.autoflush;
	}

	/**
	 * Automatically flush after each write.
	 */
	@SuppressWarnings("unchecked")
	public T autoflush(java.lang.Boolean value) {
		Object oldValue = this.autoflush;
		this.autoflush = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoflush", oldValue, value);
		return (T) this;
	}

	/**
	 * If set to true the handler is enabled and functioning as normal, if set
	 * to false the handler is ignored when processing log messages.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If set to true the handler is enabled and functioning as normal, if set
	 * to false the handler is ignored when processing log messages.
	 */
	@SuppressWarnings("unchecked")
	public T enabled(java.lang.Boolean value) {
		Object oldValue = this.enabled;
		this.enabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The character encoding used by this Handler.
	 */
	@ModelNodeBinding(detypedName = "encoding")
	public String encoding() {
		return this.encoding;
	}

	/**
	 * The character encoding used by this Handler.
	 */
	@SuppressWarnings("unchecked")
	public T encoding(java.lang.String value) {
		Object oldValue = this.encoding;
		this.encoding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("encoding", oldValue, value);
		return (T) this;
	}

	/**
	 * The file description consisting of the path and optional relative to
	 * path.
	 */
	@ModelNodeBinding(detypedName = "file")
	public Map file() {
		return this.file;
	}

	/**
	 * The file description consisting of the path and optional relative to
	 * path.
	 */
	@SuppressWarnings("unchecked")
	public T file(java.util.Map value) {
		Object oldValue = this.file;
		this.file = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("file", oldValue, value);
		return (T) this;
	}

	/**
	 * The file description consisting of the path and optional relative to
	 * path.
	 */
	@SuppressWarnings("unchecked")
	public T file(java.lang.String key, java.lang.Object value) {
		if (this.file == null) {
			this.file = new java.util.HashMap<>();
		}
		this.file.put(key, value);
		return (T) this;
	}

	/**
	 * Defines a simple filter type.
	 * 
	 * @deprecated Use filter-spec.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "filter")
	public Map filter() {
		return this.filter;
	}

	/**
	 * Defines a simple filter type.
	 * 
	 * @deprecated Use filter-spec.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T filter(java.util.Map value) {
		Object oldValue = this.filter;
		this.filter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filter", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines a simple filter type.
	 * 
	 * @deprecated Use filter-spec.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T filter(java.lang.String key, java.lang.Object value) {
		if (this.filter == null) {
			this.filter = new java.util.HashMap<>();
		}
		this.filter.put(key, value);
		return (T) this;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that
	 * does not match a pattern: not(match("JBAS.*"))
	 */
	@ModelNodeBinding(detypedName = "filter-spec")
	public String filterSpec() {
		return this.filterSpec;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that
	 * does not match a pattern: not(match("JBAS.*"))
	 */
	@SuppressWarnings("unchecked")
	public T filterSpec(java.lang.String value) {
		Object oldValue = this.filterSpec;
		this.filterSpec = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filterSpec", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines a pattern for the formatter.
	 */
	@ModelNodeBinding(detypedName = "formatter")
	public String formatter() {
		return this.formatter;
	}

	/**
	 * Defines a pattern for the formatter.
	 */
	@SuppressWarnings("unchecked")
	public T formatter(java.lang.String value) {
		Object oldValue = this.formatter;
		this.formatter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("formatter", oldValue, value);
		return (T) this;
	}

	/**
	 * The log level specifying which message levels will be logged by this
	 * logger. Message levels lower than this value will be discarded.
	 */
	@ModelNodeBinding(detypedName = "level")
	public Level level() {
		return this.level;
	}

	/**
	 * The log level specifying which message levels will be logged by this
	 * logger. Message levels lower than this value will be discarded.
	 */
	@SuppressWarnings("unchecked")
	public T level(Level value) {
		Object oldValue = this.level;
		this.level = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("level", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the handler.
	 * 
	 * @deprecated The name attribute should not be used as the handler's
	 *             address contains the name.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the handler.
	 * 
	 * @deprecated The name attribute should not be used as the handler's
	 *             address contains the name.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T name(java.lang.String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the defined formatter to be used on the handler.
	 */
	@ModelNodeBinding(detypedName = "named-formatter")
	public String namedFormatter() {
		return this.namedFormatter;
	}

	/**
	 * The name of the defined formatter to be used on the handler.
	 */
	@SuppressWarnings("unchecked")
	public T namedFormatter(java.lang.String value) {
		Object oldValue = this.namedFormatter;
		this.namedFormatter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("namedFormatter", oldValue, value);
		return (T) this;
	}
}