package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A filter to be used with handlers and loggers. Please note the name of the
 * filter should start with an alpha character and not contain any special
 * characters. The following names are considered reserved names; accept, deny,
 * not, all, any, levelChange, levels, levelRange, match, substitute,
 * substituteAll.
 */
@Addresses({"/subsystem=logging/logging-profile=*/filter=*",
		"/subsystem=logging/filter=*"})
@ResourceType("filter")
public class Filter<T extends Filter<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The logging filter class to be used.")
	private String attributeClass;
	@AttributeDocumentation("Defines the constructor properties used for the logging filter.")
	private Map constructorProperties;
	@AttributeDocumentation("The module that the logging filter depends on.")
	private String module;
	@AttributeDocumentation("Defines the properties used for the logging filter. All properties must be accessible via a setter method.")
	private Map properties;

	public Filter(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The logging filter class to be used.
	 */
	@ModelNodeBinding(detypedName = "class")
	public String attributeClass() {
		return this.attributeClass;
	}

	/**
	 * The logging filter class to be used.
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(java.lang.String value) {
		Object oldValue = this.attributeClass;
		this.attributeClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeClass", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the constructor properties used for the logging filter.
	 */
	@ModelNodeBinding(detypedName = "constructor-properties")
	public Map constructorProperties() {
		return this.constructorProperties;
	}

	/**
	 * Defines the constructor properties used for the logging filter.
	 */
	@SuppressWarnings("unchecked")
	public T constructorProperties(java.util.Map value) {
		Object oldValue = this.constructorProperties;
		this.constructorProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("constructorProperties", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Defines the constructor properties used for the logging filter.
	 */
	@SuppressWarnings("unchecked")
	public T constructorProperty(java.lang.String key, java.lang.Object value) {
		if (this.constructorProperties == null) {
			this.constructorProperties = new java.util.HashMap<>();
		}
		this.constructorProperties.put(key, value);
		return (T) this;
	}

	/**
	 * The module that the logging filter depends on.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module that the logging filter depends on.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the properties used for the logging filter. All properties must
	 * be accessible via a setter method.
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * Defines the properties used for the logging filter. All properties must
	 * be accessible via a setter method.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.Map value) {
		Object oldValue = this.properties;
		this.properties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("properties", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the properties used for the logging filter. All properties must
	 * be accessible via a setter method.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.properties == null) {
			this.properties = new java.util.HashMap<>();
		}
		this.properties.put(key, value);
		return (T) this;
	}
}