package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.Filter;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface FilterConsumer<T extends Filter<T>> {

	/**
	 * Configure a pre-constructed instance of Filter resource
	 * 
	 * @parameter Instance of Filter to configure
	 * @return nothing
	 */
	void accept(T value);

	default FilterConsumer<T> andThen(FilterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}