package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PeriodicSizeRotatingFileHandlerConsumer<T extends PeriodicSizeRotatingFileHandler<T>> {

	/**
	 * Configure a pre-constructed instance of PeriodicSizeRotatingFileHandler
	 * resource
	 * 
	 * @parameter Instance of PeriodicSizeRotatingFileHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default PeriodicSizeRotatingFileHandlerConsumer<T> andThen(
			PeriodicSizeRotatingFileHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}