package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.logging.Level;

/**
 * Defines the root logger for this log context.
 */
@Address("/subsystem=logging/root-logger=ROOT")
@ResourceType("root-logger")
@Implicit
public class RootLogger<T extends RootLogger<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Defines a simple filter type.")
	private Map filter;
	@AttributeDocumentation("A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match(\"JBAS.*\"))")
	private String filterSpec;
	@AttributeDocumentation("The handlers associated with the root logger.")
	private List<String> handlers;
	@AttributeDocumentation("The log level specifying which message levels will be logged by the root logger. Message levels lower than this value will be discarded.")
	private Level level;

	public RootLogger() {
		super();
		this.key = "ROOT";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Defines a simple filter type.
	 * 
	 * @deprecated Use filter-spec.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "filter")
	public Map filter() {
		return this.filter;
	}

	/**
	 * Defines a simple filter type.
	 * 
	 * @deprecated Use filter-spec.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T filter(java.util.Map value) {
		Object oldValue = this.filter;
		this.filter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filter", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines a simple filter type.
	 * 
	 * @deprecated Use filter-spec.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T filter(java.lang.String key, java.lang.Object value) {
		if (this.filter == null) {
			this.filter = new java.util.HashMap<>();
		}
		this.filter.put(key, value);
		return (T) this;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that
	 * does not match a pattern: not(match("JBAS.*"))
	 */
	@ModelNodeBinding(detypedName = "filter-spec")
	public String filterSpec() {
		return this.filterSpec;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that
	 * does not match a pattern: not(match("JBAS.*"))
	 */
	@SuppressWarnings("unchecked")
	public T filterSpec(java.lang.String value) {
		Object oldValue = this.filterSpec;
		this.filterSpec = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filterSpec", oldValue, value);
		return (T) this;
	}

	/**
	 * The handlers associated with the root logger.
	 */
	@ModelNodeBinding(detypedName = "handlers")
	public List<String> handlers() {
		return this.handlers;
	}

	/**
	 * The handlers associated with the root logger.
	 */
	@SuppressWarnings("unchecked")
	public T handlers(java.util.List<String> value) {
		Object oldValue = this.handlers;
		this.handlers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("handlers", oldValue, value);
		return (T) this;
	}

	/**
	 * The handlers associated with the root logger.
	 */
	@SuppressWarnings("unchecked")
	public T handler(String value) {
		if (this.handlers == null) {
			this.handlers = new java.util.ArrayList<>();
		}
		this.handlers.add(value);
		return (T) this;
	}

	/**
	 * The handlers associated with the root logger.
	 */
	@SuppressWarnings("unchecked")
	public T handlers(String... args) {
		handlers(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The log level specifying which message levels will be logged by the root
	 * logger. Message levels lower than this value will be discarded.
	 */
	@ModelNodeBinding(detypedName = "level")
	public Level level() {
		return this.level;
	}

	/**
	 * The log level specifying which message levels will be logged by the root
	 * logger. Message levels lower than this value will be discarded.
	 */
	@SuppressWarnings("unchecked")
	public T level(Level value) {
		Object oldValue = this.level;
		this.level = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("level", oldValue, value);
		return (T) this;
	}
}