package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.SocketHandler;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SocketHandlerConsumer<T extends SocketHandler<T>> {

	/**
	 * Configure a pre-constructed instance of SocketHandler resource
	 * 
	 * @parameter Instance of SocketHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default SocketHandlerConsumer<T> andThen(SocketHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}