package org.wildfly.swarm.config.logging;
public enum Target {
	CONSOLE("console"), SYSTEM_OUT("System.out"), SYSTEM_ERR("System.err");

	private final String allowedValue;

	/**
	 * Returns the allowed value for the management model.
	 * 
	 * @return the allowed model value
	 */
	public String getAllowedValue() {
		return allowedValue;
	}

	Target(java.lang.String allowedValue) {
		this.allowedValue = allowedValue;
	}

	@Override
	public String toString() {
		return allowedValue;
	}
}