package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.logging.ExceptionOutputType;
import java.util.Map;

/**
 * A formatter that formats log messages in XML.
 */
@Addresses({"/subsystem=logging/logging-profile=*/xml-formatter=*",
		"/subsystem=logging/xml-formatter=*"})
@ResourceType("xml-formatter")
public class XmlFormatter<T extends XmlFormatter<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The date/time format pattern. The pattern must be a valid java.time.format.DateTimeFormatter.ofPattern() pattern. The default pattern is an ISO-8601 extended offset date-time format.")
	private String dateFormat;
	@AttributeDocumentation("Indicates how the cause of the logged message, if one is available, will be added to the XML output.")
	private ExceptionOutputType exceptionOutputType;
	@AttributeDocumentation("Allows the names of the keys for the XML properties to be overridden.")
	private Map keyOverrides;
	@AttributeDocumentation("Sets the meta data to use in the XML format. Properties will be added to each log message.")
	private Map metaData;
	@AttributeDocumentation("Sets the namespace URI used for each record if print-namespace attribute is true. Note that if no namespace-uri is defined and there are overridden keys no namespace will be written regardless if the print-namespace attribute is set to true.")
	private String namespaceUri;
	@AttributeDocumentation("Indicates whether or not pretty printing should be used when formatting.")
	private Boolean prettyPrint;
	@AttributeDocumentation("Sets whether or not details should be printed. Printing the details can be expensive as the values are retrieved from the caller. The details include the source class name, source file name, source method name, source module name, source module version and source line number.")
	private Boolean printDetails;
	@AttributeDocumentation("Turns on or off the printing of the namespace for each <record/>. This is set to false by default.")
	private Boolean printNamespace;
	@AttributeDocumentation("The value to be used to indicate the end of a record. If set to null no delimiter will be used at the end of the record. The default value is a line feed.")
	private String recordDelimiter;
	@AttributeDocumentation("The zone ID for formatting the date and time. The system default is used if left undefined.")
	private String zoneId;

	public XmlFormatter(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The date/time format pattern. The pattern must be a valid
	 * java.time.format.DateTimeFormatter.ofPattern() pattern. The default
	 * pattern is an ISO-8601 extended offset date-time format.
	 */
	@ModelNodeBinding(detypedName = "date-format")
	public String dateFormat() {
		return this.dateFormat;
	}

	/**
	 * The date/time format pattern. The pattern must be a valid
	 * java.time.format.DateTimeFormatter.ofPattern() pattern. The default
	 * pattern is an ISO-8601 extended offset date-time format.
	 */
	@SuppressWarnings("unchecked")
	public T dateFormat(java.lang.String value) {
		Object oldValue = this.dateFormat;
		this.dateFormat = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dateFormat", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates how the cause of the logged message, if one is available, will
	 * be added to the XML output.
	 */
	@ModelNodeBinding(detypedName = "exception-output-type")
	public ExceptionOutputType exceptionOutputType() {
		return this.exceptionOutputType;
	}

	/**
	 * Indicates how the cause of the logged message, if one is available, will
	 * be added to the XML output.
	 */
	@SuppressWarnings("unchecked")
	public T exceptionOutputType(ExceptionOutputType value) {
		Object oldValue = this.exceptionOutputType;
		this.exceptionOutputType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("exceptionOutputType", oldValue, value);
		return (T) this;
	}

	/**
	 * Allows the names of the keys for the XML properties to be overridden.
	 */
	@ModelNodeBinding(detypedName = "key-overrides")
	public Map keyOverrides() {
		return this.keyOverrides;
	}

	/**
	 * Allows the names of the keys for the XML properties to be overridden.
	 */
	@SuppressWarnings("unchecked")
	public T keyOverrides(java.util.Map value) {
		Object oldValue = this.keyOverrides;
		this.keyOverrides = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyOverrides", oldValue, value);
		return (T) this;
	}

	/**
	 * Allows the names of the keys for the XML properties to be overridden.
	 */
	@SuppressWarnings("unchecked")
	public T keyOverride(java.lang.String key, java.lang.Object value) {
		if (this.keyOverrides == null) {
			this.keyOverrides = new java.util.HashMap<>();
		}
		this.keyOverrides.put(key, value);
		return (T) this;
	}

	/**
	 * Sets the meta data to use in the XML format. Properties will be added to
	 * each log message.
	 */
	@ModelNodeBinding(detypedName = "meta-data")
	public Map metaData() {
		return this.metaData;
	}

	/**
	 * Sets the meta data to use in the XML format. Properties will be added to
	 * each log message.
	 */
	@SuppressWarnings("unchecked")
	public T metaData(java.util.Map value) {
		Object oldValue = this.metaData;
		this.metaData = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("metaData", oldValue, value);
		return (T) this;
	}

	/**
	 * Sets the meta data to use in the XML format. Properties will be added to
	 * each log message.
	 */
	@SuppressWarnings("unchecked")
	public T metaDatum(java.lang.String key, java.lang.Object value) {
		if (this.metaData == null) {
			this.metaData = new java.util.HashMap<>();
		}
		this.metaData.put(key, value);
		return (T) this;
	}

	/**
	 * Sets the namespace URI used for each record if print-namespace attribute
	 * is true. Note that if no namespace-uri is defined and there are
	 * overridden keys no namespace will be written regardless if the
	 * print-namespace attribute is set to true.
	 */
	@ModelNodeBinding(detypedName = "namespace-uri")
	public String namespaceUri() {
		return this.namespaceUri;
	}

	/**
	 * Sets the namespace URI used for each record if print-namespace attribute
	 * is true. Note that if no namespace-uri is defined and there are
	 * overridden keys no namespace will be written regardless if the
	 * print-namespace attribute is set to true.
	 */
	@SuppressWarnings("unchecked")
	public T namespaceUri(java.lang.String value) {
		Object oldValue = this.namespaceUri;
		this.namespaceUri = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("namespaceUri", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether or not pretty printing should be used when formatting.
	 */
	@ModelNodeBinding(detypedName = "pretty-print")
	public Boolean prettyPrint() {
		return this.prettyPrint;
	}

	/**
	 * Indicates whether or not pretty printing should be used when formatting.
	 */
	@SuppressWarnings("unchecked")
	public T prettyPrint(java.lang.Boolean value) {
		Object oldValue = this.prettyPrint;
		this.prettyPrint = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("prettyPrint", oldValue, value);
		return (T) this;
	}

	/**
	 * Sets whether or not details should be printed. Printing the details can
	 * be expensive as the values are retrieved from the caller. The details
	 * include the source class name, source file name, source method name,
	 * source module name, source module version and source line number.
	 */
	@ModelNodeBinding(detypedName = "print-details")
	public Boolean printDetails() {
		return this.printDetails;
	}

	/**
	 * Sets whether or not details should be printed. Printing the details can
	 * be expensive as the values are retrieved from the caller. The details
	 * include the source class name, source file name, source method name,
	 * source module name, source module version and source line number.
	 */
	@SuppressWarnings("unchecked")
	public T printDetails(java.lang.Boolean value) {
		Object oldValue = this.printDetails;
		this.printDetails = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("printDetails", oldValue, value);
		return (T) this;
	}

	/**
	 * Turns on or off the printing of the namespace for each <record/>. This is
	 * set to false by default.
	 */
	@ModelNodeBinding(detypedName = "print-namespace")
	public Boolean printNamespace() {
		return this.printNamespace;
	}

	/**
	 * Turns on or off the printing of the namespace for each <record/>. This is
	 * set to false by default.
	 */
	@SuppressWarnings("unchecked")
	public T printNamespace(java.lang.Boolean value) {
		Object oldValue = this.printNamespace;
		this.printNamespace = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("printNamespace", oldValue, value);
		return (T) this;
	}

	/**
	 * The value to be used to indicate the end of a record. If set to null no
	 * delimiter will be used at the end of the record. The default value is a
	 * line feed.
	 */
	@ModelNodeBinding(detypedName = "record-delimiter")
	public String recordDelimiter() {
		return this.recordDelimiter;
	}

	/**
	 * The value to be used to indicate the end of a record. If set to null no
	 * delimiter will be used at the end of the record. The default value is a
	 * line feed.
	 */
	@SuppressWarnings("unchecked")
	public T recordDelimiter(java.lang.String value) {
		Object oldValue = this.recordDelimiter;
		this.recordDelimiter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recordDelimiter", oldValue, value);
		return (T) this;
	}

	/**
	 * The zone ID for formatting the date and time. The system default is used
	 * if left undefined.
	 */
	@ModelNodeBinding(detypedName = "zone-id")
	public String zoneId() {
		return this.zoneId;
	}

	/**
	 * The zone ID for formatting the date and time. The system default is used
	 * if left undefined.
	 */
	@SuppressWarnings("unchecked")
	public T zoneId(java.lang.String value) {
		Object oldValue = this.zoneId;
		this.zoneId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("zoneId", oldValue, value);
		return (T) this;
	}
}