package org.wildfly.swarm.config.logging.logging_profile;

import org.wildfly.swarm.config.logging.logging_profile.ConsoleHandler;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConsoleHandlerConsumer<T extends ConsoleHandler<T>> {

	/**
	 * Configure a pre-constructed instance of ConsoleHandler resource
	 * 
	 * @parameter Instance of ConsoleHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConsoleHandlerConsumer<T> andThen(ConsoleHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}