package org.wildfly.swarm.config.logging.logging_profile;

import org.wildfly.swarm.config.logging.logging_profile.CustomHandler;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomHandlerConsumer<T extends CustomHandler<T>> {

	/**
	 * Configure a pre-constructed instance of CustomHandler resource
	 * 
	 * @parameter Instance of CustomHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomHandlerConsumer<T> andThen(CustomHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}