package org.wildfly.swarm.config.logging.logging_profile;

import org.wildfly.swarm.config.logging.logging_profile.RootLogger;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RootLoggerConsumer<T extends RootLogger<T>> {

	/**
	 * Configure a pre-constructed instance of RootLogger resource
	 * 
	 * @parameter Instance of RootLogger to configure
	 * @return nothing
	 */
	void accept(T value);

	default RootLoggerConsumer<T> andThen(RootLoggerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}