package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * Configuration of the server's HTTP management interface
 */
@Address("/core-service=management/management-interface=http-interface")
@ResourceType("management-interface")
@Implicit
public class HTTPInterfaceManagementInterface<T extends HTTPInterfaceManagementInterface<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Comma separated list of trusted Origins for sending Cross-Origin Resource Sharing requests on the management API once the user is authenticated.")
	private List<String> allowedOrigins;
	@AttributeDocumentation("Flag that indicates admin console is enabled")
	private Boolean consoleEnabled;
	@AttributeDocumentation("The authentication policy to use to secure the interface for normal HTTP requests.")
	private String httpAuthenticationFactory;
	@AttributeDocumentation("HTTP Upgrade specific configuration")
	private Map httpUpgrade;
	@AttributeDocumentation("Flag that indicates HTTP Upgrade is enabled, which allows HTTP requests to be upgraded to native remoting connections")
	private Boolean httpUpgradeEnabled;
	@AttributeDocumentation("The name of the protocol to be passed to the SASL mechanisms used for authentication.")
	private String saslProtocol;
	@AttributeDocumentation("The name of the socket binding configuration to use for the HTTPS management interface's socket.  When defined at least one of ssl-context or security-realm must also be defined.")
	private String secureSocketBinding;
	@AttributeDocumentation("The legacy security realm to use for the HTTP management interface.")
	private String securityRealm;
	@AttributeDocumentation("The name of the server used in the initial Remoting exchange and within the SASL mechanisms.")
	private String serverName;
	@AttributeDocumentation("The name of the socket binding configuration to use for the HTTP management interface's socket.")
	private String socketBinding;
	@AttributeDocumentation("Reference to the SSLContext to use for this management interface.")
	private String sslContext;

	public HTTPInterfaceManagementInterface() {
		super();
		this.key = "http-interface";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Comma separated list of trusted Origins for sending Cross-Origin Resource
	 * Sharing requests on the management API once the user is authenticated.
	 */
	@ModelNodeBinding(detypedName = "allowed-origins")
	public List<String> allowedOrigins() {
		return this.allowedOrigins;
	}

	/**
	 * Comma separated list of trusted Origins for sending Cross-Origin Resource
	 * Sharing requests on the management API once the user is authenticated.
	 */
	@SuppressWarnings("unchecked")
	public T allowedOrigins(java.util.List<String> value) {
		Object oldValue = this.allowedOrigins;
		this.allowedOrigins = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowedOrigins", oldValue, value);
		return (T) this;
	}

	/**
	 * Comma separated list of trusted Origins for sending Cross-Origin Resource
	 * Sharing requests on the management API once the user is authenticated.
	 */
	@SuppressWarnings("unchecked")
	public T allowedOrigin(String value) {
		if (this.allowedOrigins == null) {
			this.allowedOrigins = new java.util.ArrayList<>();
		}
		this.allowedOrigins.add(value);
		return (T) this;
	}

	/**
	 * Comma separated list of trusted Origins for sending Cross-Origin Resource
	 * Sharing requests on the management API once the user is authenticated.
	 */
	@SuppressWarnings("unchecked")
	public T allowedOrigins(String... args) {
		allowedOrigins(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Flag that indicates admin console is enabled
	 */
	@ModelNodeBinding(detypedName = "console-enabled")
	public Boolean consoleEnabled() {
		return this.consoleEnabled;
	}

	/**
	 * Flag that indicates admin console is enabled
	 */
	@SuppressWarnings("unchecked")
	public T consoleEnabled(java.lang.Boolean value) {
		Object oldValue = this.consoleEnabled;
		this.consoleEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("consoleEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The authentication policy to use to secure the interface for normal HTTP
	 * requests.
	 */
	@ModelNodeBinding(detypedName = "http-authentication-factory")
	public String httpAuthenticationFactory() {
		return this.httpAuthenticationFactory;
	}

	/**
	 * The authentication policy to use to secure the interface for normal HTTP
	 * requests.
	 */
	@SuppressWarnings("unchecked")
	public T httpAuthenticationFactory(java.lang.String value) {
		Object oldValue = this.httpAuthenticationFactory;
		this.httpAuthenticationFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpAuthenticationFactory", oldValue,
					value);
		return (T) this;
	}

	/**
	 * HTTP Upgrade specific configuration
	 */
	@ModelNodeBinding(detypedName = "http-upgrade")
	public Map httpUpgrade() {
		return this.httpUpgrade;
	}

	/**
	 * HTTP Upgrade specific configuration
	 */
	@SuppressWarnings("unchecked")
	public T httpUpgrade(java.util.Map value) {
		Object oldValue = this.httpUpgrade;
		this.httpUpgrade = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpUpgrade", oldValue, value);
		return (T) this;
	}

	/**
	 * HTTP Upgrade specific configuration
	 */
	@SuppressWarnings("unchecked")
	public T httpUpgrade(java.lang.String key, java.lang.Object value) {
		if (this.httpUpgrade == null) {
			this.httpUpgrade = new java.util.HashMap<>();
		}
		this.httpUpgrade.put(key, value);
		return (T) this;
	}

	/**
	 * Flag that indicates HTTP Upgrade is enabled, which allows HTTP requests
	 * to be upgraded to native remoting connections
	 * 
	 * @deprecated Instead use http-upgrade.enabled
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "http-upgrade-enabled")
	public Boolean httpUpgradeEnabled() {
		return this.httpUpgradeEnabled;
	}

	/**
	 * Flag that indicates HTTP Upgrade is enabled, which allows HTTP requests
	 * to be upgraded to native remoting connections
	 * 
	 * @deprecated Instead use http-upgrade.enabled
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T httpUpgradeEnabled(java.lang.Boolean value) {
		Object oldValue = this.httpUpgradeEnabled;
		this.httpUpgradeEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpUpgradeEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the protocol to be passed to the SASL mechanisms used for
	 * authentication.
	 * 
	 * @deprecated Only for use with the legacy security realms.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * The name of the protocol to be passed to the SASL mechanisms used for
	 * authentication.
	 * 
	 * @deprecated Only for use with the legacy security realms.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T saslProtocol(java.lang.String value) {
		Object oldValue = this.saslProtocol;
		this.saslProtocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslProtocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the socket binding configuration to use for the HTTPS
	 * management interface's socket. When defined at least one of ssl-context
	 * or security-realm must also be defined.
	 */
	@ModelNodeBinding(detypedName = "secure-socket-binding")
	public String secureSocketBinding() {
		return this.secureSocketBinding;
	}

	/**
	 * The name of the socket binding configuration to use for the HTTPS
	 * management interface's socket. When defined at least one of ssl-context
	 * or security-realm must also be defined.
	 */
	@SuppressWarnings("unchecked")
	public T secureSocketBinding(java.lang.String value) {
		Object oldValue = this.secureSocketBinding;
		this.secureSocketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("secureSocketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * The legacy security realm to use for the HTTP management interface.
	 * 
	 * @deprecated Configuration should migrate to reference
	 *             'http-authentication-factory', 'sasl-authentication-factory',
	 *             and 'ssl-context' capabilities as required.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The legacy security realm to use for the HTTP management interface.
	 * 
	 * @deprecated Configuration should migrate to reference
	 *             'http-authentication-factory', 'sasl-authentication-factory',
	 *             and 'ssl-context' capabilities as required.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T securityRealm(java.lang.String value) {
		Object oldValue = this.securityRealm;
		this.securityRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the server used in the initial Remoting exchange and within
	 * the SASL mechanisms.
	 * 
	 * @deprecated Only for use with the legacy security realms.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The name of the server used in the initial Remoting exchange and within
	 * the SASL mechanisms.
	 * 
	 * @deprecated Only for use with the legacy security realms.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T serverName(java.lang.String value) {
		Object oldValue = this.serverName;
		this.serverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the socket binding configuration to use for the HTTP
	 * management interface's socket.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The name of the socket binding configuration to use for the HTTP
	 * management interface's socket.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to the SSLContext to use for this management interface.
	 */
	@ModelNodeBinding(detypedName = "ssl-context")
	public String sslContext() {
		return this.sslContext;
	}

	/**
	 * Reference to the SSLContext to use for this management interface.
	 */
	@SuppressWarnings("unchecked")
	public T sslContext(java.lang.String value) {
		Object oldValue = this.sslContext;
		this.sslContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sslContext", oldValue, value);
		return (T) this;
	}
}