package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.LdapConnection;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LdapConnectionConsumer<T extends LdapConnection<T>> {

	/**
	 * Configure a pre-constructed instance of LdapConnection resource
	 * 
	 * @parameter Instance of LdapConnection to configure
	 * @return nothing
	 */
	void accept(T value);

	default LdapConnectionConsumer<T> andThen(LdapConnectionConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}