package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration of the server's native management interface
 */
@Address("/core-service=management/management-interface=native-interface")
@ResourceType("management-interface")
@Implicit
public class NativeInterfaceManagementInterface<T extends NativeInterfaceManagementInterface<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The SASL authentication policy to use to secure this interface.")
	private String saslAuthenticationFactory;
	@AttributeDocumentation("The name of the protocol to be passed to the SASL mechanisms used for authentication.")
	private String saslProtocol;
	@AttributeDocumentation("The legacy security realm to use for the native management interface.")
	private String securityRealm;
	@AttributeDocumentation("The name of the server used in the initial Remoting exchange and within the SASL mechanisms.")
	private String serverName;
	@AttributeDocumentation("The name of the socket binding configuration to use for the native management interface's socket.")
	private String socketBinding;
	@AttributeDocumentation("Reference to the SSLContext to use for this management interface.")
	private String sslContext;

	public NativeInterfaceManagementInterface() {
		super();
		this.key = "native-interface";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The SASL authentication policy to use to secure this interface.
	 */
	@ModelNodeBinding(detypedName = "sasl-authentication-factory")
	public String saslAuthenticationFactory() {
		return this.saslAuthenticationFactory;
	}

	/**
	 * The SASL authentication policy to use to secure this interface.
	 */
	@SuppressWarnings("unchecked")
	public T saslAuthenticationFactory(java.lang.String value) {
		Object oldValue = this.saslAuthenticationFactory;
		this.saslAuthenticationFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslAuthenticationFactory", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The name of the protocol to be passed to the SASL mechanisms used for
	 * authentication.
	 * 
	 * @deprecated Only for use with the legacy security realms.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * The name of the protocol to be passed to the SASL mechanisms used for
	 * authentication.
	 * 
	 * @deprecated Only for use with the legacy security realms.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T saslProtocol(java.lang.String value) {
		Object oldValue = this.saslProtocol;
		this.saslProtocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslProtocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The legacy security realm to use for the native management interface.
	 * 
	 * @deprecated Configuration should migrate to reference a
	 *             'sasl-authentication-factory' and 'ssl-context' as required.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The legacy security realm to use for the native management interface.
	 * 
	 * @deprecated Configuration should migrate to reference a
	 *             'sasl-authentication-factory' and 'ssl-context' as required.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T securityRealm(java.lang.String value) {
		Object oldValue = this.securityRealm;
		this.securityRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the server used in the initial Remoting exchange and within
	 * the SASL mechanisms.
	 * 
	 * @deprecated Only for use with the legacy security realms.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The name of the server used in the initial Remoting exchange and within
	 * the SASL mechanisms.
	 * 
	 * @deprecated Only for use with the legacy security realms.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T serverName(java.lang.String value) {
		Object oldValue = this.serverName;
		this.serverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the socket binding configuration to use for the native
	 * management interface's socket.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The name of the socket binding configuration to use for the native
	 * management interface's socket.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to the SSLContext to use for this management interface.
	 */
	@ModelNodeBinding(detypedName = "ssl-context")
	public String sslContext() {
		return this.sslContext;
	}

	/**
	 * Reference to the SSLContext to use for this management interface.
	 */
	@SuppressWarnings("unchecked")
	public T sslContext(java.lang.String value) {
		Object oldValue = this.sslContext;
		this.sslContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sslContext", oldValue, value);
		return (T) this;
	}
}