package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.VaultExpressionConstraint;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface VaultExpressionConstraintConsumer<T extends VaultExpressionConstraint<T>> {

	/**
	 * Configure a pre-constructed instance of VaultExpressionConstraint
	 * resource
	 * 
	 * @parameter Instance of VaultExpressionConstraint to configure
	 * @return nothing
	 */
	void accept(T value);

	default VaultExpressionConstraintConsumer<T> andThen(
			VaultExpressionConstraintConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}