package org.wildfly.swarm.config.management.access.role_mapping;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.management.core.service.Type;

/**
 * An individual principal used within a role mapping.
 */
@Address("/core-service=management/access=authorization/role-mapping=*/exclude=*")
@ResourceType("exclude")
public class Exclude<T extends Exclude<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the user or group being mapped.")
	private String name;
	@AttributeDocumentation("An optional attribute to map based on the realm used for authentication.")
	private String realm;
	@AttributeDocumentation("The type of the Principal being mapped, either 'group' or 'user'.")
	private Type type;

	public Exclude(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the user or group being mapped.
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the user or group being mapped.
	 */
	@SuppressWarnings("unchecked")
	public T name(java.lang.String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}

	/**
	 * An optional attribute to map based on the realm used for authentication.
	 * 
	 * @deprecated This attribute is no longer used once management security is
	 *             migrated to Elytron based security.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "realm")
	public String realm() {
		return this.realm;
	}

	/**
	 * An optional attribute to map based on the realm used for authentication.
	 * 
	 * @deprecated This attribute is no longer used once management security is
	 *             migrated to Elytron based security.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T realm(java.lang.String value) {
		Object oldValue = this.realm;
		this.realm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realm", oldValue, value);
		return (T) this;
	}

	/**
	 * The type of the Principal being mapped, either 'group' or 'user'.
	 */
	@ModelNodeBinding(detypedName = "type")
	public Type type() {
		return this.type;
	}

	/**
	 * The type of the Principal being mapped, either 'group' or 'user'.
	 */
	@SuppressWarnings("unchecked")
	public T type(Type value) {
		Object oldValue = this.type;
		this.type = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("type", oldValue, value);
		return (T) this;
	}
}