package org.wildfly.swarm.config.management.access.syslog_handler;

import org.wildfly.swarm.config.management.access.syslog_handler.TlsProtocol;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface TlsProtocolConsumer<T extends TlsProtocol<T>> {

	/**
	 * Configure a pre-constructed instance of TlsProtocol resource
	 * 
	 * @parameter Instance of TlsProtocol to configure
	 * @return nothing
	 */
	void accept(T value);

	default TlsProtocolConsumer<T> andThen(TlsProtocolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}