package org.wildfly.swarm.config.management.access.syslog_handler.protocol;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Configuration for the truststore for the server certificate, if not signed by
 * an authority.
 */
@Address("/core-service=management/access=audit/syslog-handler=*/protocol=tls/authentication=truststore")
@ResourceType("authentication")
@Implicit
public class TruststoreAuthentication<T extends TruststoreAuthentication<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The password for the truststore.")
	private String keystorePassword;
	@AttributeDocumentation("The reference to credential for the truststore password stored in CredentialStore under defined alias or clear text password.")
	private Map keystorePasswordCredentialReference;
	@AttributeDocumentation("The path of the truststore.")
	private String keystorePath;
	@AttributeDocumentation("The name of another previously named path, or of one of the standard paths provided by the system. If 'keystore-relative-to' is provided, the value of the 'keystore-path' attribute is treated as relative to the path specified by this attribute.")
	private String keystoreRelativeTo;

	public TruststoreAuthentication() {
		super();
		this.key = "truststore";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The password for the truststore.
	 */
	@ModelNodeBinding(detypedName = "keystore-password")
	public String keystorePassword() {
		return this.keystorePassword;
	}

	/**
	 * The password for the truststore.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePassword(java.lang.String value) {
		Object oldValue = this.keystorePassword;
		this.keystorePassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystorePassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The reference to credential for the truststore password stored in
	 * CredentialStore under defined alias or clear text password.
	 */
	@ModelNodeBinding(detypedName = "keystore-password-credential-reference")
	public Map keystorePasswordCredentialReference() {
		return this.keystorePasswordCredentialReference;
	}

	/**
	 * The reference to credential for the truststore password stored in
	 * CredentialStore under defined alias or clear text password.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePasswordCredentialReference(java.util.Map value) {
		Object oldValue = this.keystorePasswordCredentialReference;
		this.keystorePasswordCredentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystorePasswordCredentialReference",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The reference to credential for the truststore password stored in
	 * CredentialStore under defined alias or clear text password.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePasswordCredentialReference(java.lang.String key,
			java.lang.Object value) {
		if (this.keystorePasswordCredentialReference == null) {
			this.keystorePasswordCredentialReference = new java.util.HashMap<>();
		}
		this.keystorePasswordCredentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The path of the truststore.
	 */
	@ModelNodeBinding(detypedName = "keystore-path")
	public String keystorePath() {
		return this.keystorePath;
	}

	/**
	 * The path of the truststore.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePath(java.lang.String value) {
		Object oldValue = this.keystorePath;
		this.keystorePath = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystorePath", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'keystore-relative-to' is provided, the
	 * value of the 'keystore-path' attribute is treated as relative to the path
	 * specified by this attribute.
	 */
	@ModelNodeBinding(detypedName = "keystore-relative-to")
	public String keystoreRelativeTo() {
		return this.keystoreRelativeTo;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'keystore-relative-to' is provided, the
	 * value of the 'keystore-path' attribute is treated as relative to the path
	 * specified by this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T keystoreRelativeTo(java.lang.String value) {
		Object oldValue = this.keystoreRelativeTo;
		this.keystoreRelativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystoreRelativeTo", oldValue, value);
		return (T) this;
	}
}