package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.PropertiesAuthorization;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PropertiesAuthorizationConsumer<T extends PropertiesAuthorization<T>> {

	/**
	 * Configure a pre-constructed instance of PropertiesAuthorization resource
	 * 
	 * @parameter Instance of PropertiesAuthorization to configure
	 * @return nothing
	 */
	void accept(T value);

	default PropertiesAuthorizationConsumer<T> andThen(
			PropertiesAuthorizationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}