package org.wildfly.swarm.config.management.security_realm.authorization;

import org.wildfly.swarm.config.management.security_realm.authorization.GroupToPrincipalGroupSearch;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface GroupToPrincipalGroupSearchConsumer<T extends GroupToPrincipalGroupSearch<T>> {

	/**
	 * Configure a pre-constructed instance of GroupToPrincipalGroupSearch
	 * resource
	 * 
	 * @parameter Instance of GroupToPrincipalGroupSearch to configure
	 * @return nothing
	 */
	void accept(T value);

	default GroupToPrincipalGroupSearchConsumer<T> andThen(
			GroupToPrincipalGroupSearchConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}