package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Defines a JMS queue to a remote broker.
 */
@Address("/subsystem=messaging-activemq/external-jms-queue=*")
@ResourceType("external-jms-queue")
public class ExternalJMSQueue<T extends ExternalJMSQueue<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The jndi names the queue will be bound to.")
	private List<String> entries;

	public ExternalJMSQueue(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(java.util.List<String> value) {
		Object oldValue = this.entries;
		this.entries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("entries", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entry(String value) {
		if (this.entries == null) {
			this.entries = new java.util.ArrayList<>();
		}
		this.entries.add(value);
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(String... args) {
		entries(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}