package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.messaging.activemq.ExternalJMSQueue;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ExternalJMSQueueConsumer<T extends ExternalJMSQueue<T>> {

	/**
	 * Configure a pre-constructed instance of ExternalJMSQueue resource
	 * 
	 * @parameter Instance of ExternalJMSQueue to configure
	 * @return nothing
	 */
	void accept(T value);

	default ExternalJMSQueueConsumer<T> andThen(
			ExternalJMSQueueConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}