package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.messaging.activemq.ExternalJMSTopic;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ExternalJMSTopicConsumer<T extends ExternalJMSTopic<T>> {

	/**
	 * Configure a pre-constructed instance of ExternalJMSTopic resource
	 * 
	 * @parameter Instance of ExternalJMSTopic to configure
	 * @return nothing
	 */
	void accept(T value);

	default ExternalJMSTopicConsumer<T> andThen(
			ExternalJMSTopicConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}