package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PooledConnectionFactoryConsumer<T extends PooledConnectionFactory<T>> {

	/**
	 * Configure a pre-constructed instance of PooledConnectionFactory resource
	 * 
	 * @parameter Instance of PooledConnectionFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default PooledConnectionFactoryConsumer<T> andThen(
			PooledConnectionFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}