package org.wildfly.swarm.config.messaging.activemq;
public enum Transaction {
	LOCAL("local"), NONE("none"), XA("xa");

	private final String allowedValue;

	/**
	 * Returns the allowed value for the management model.
	 * 
	 * @return the allowed model value
	 */
	public String getAllowedValue() {
		return allowedValue;
	}

	Transaction(java.lang.String allowedValue) {
		this.allowedValue = allowedValue;
	}

	@Override
	public String toString() {
		return allowedValue;
	}
}