package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Cluster connections group servers into clusters so that messages can be load
 * balanced between the nodes of the cluster.
 */
@Address("/subsystem=messaging-activemq/server=*/cluster-connection=*")
@ResourceType("cluster-connection")
public class ClusterConnection<T extends ClusterConnection<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Whether, if a node learns of the existence of a node that is more than 1 hop away, we do not create a bridge for direct cluster connection. Only relevant if 'static-connectors' is defined.")
	private Boolean allowDirectConnectionsOnly;
	@AttributeDocumentation("The timeout to use when fail over is in process (in ms) for remote calls made by the cluster connection.")
	private Long callFailoverTimeout;
	@AttributeDocumentation("The timeout (in ms) for remote calls made by the cluster connection.")
	private Long callTimeout;
	@AttributeDocumentation("The period (in milliseconds) between client failure check.")
	private Long checkPeriod;
	@AttributeDocumentation("Each cluster connection only applies to messages sent to an address that starts with this value.")
	private String clusterConnectionAddress;
	@AttributeDocumentation("The confirmation-window-size to use for the connection used to forward messages to a target node.")
	private Integer confirmationWindowSize;
	@AttributeDocumentation("The maximum time (in milliseconds) for which the connections used by the cluster connections are considered alive (in the absence of heartbeat).")
	private Long connectionTtl;
	@AttributeDocumentation("The name of connector to use for live connection")
	private String connectorName;
	@AttributeDocumentation("The discovery group used to obtain the list of other servers in the cluster to which this cluster connection will make connections. Must be undefined (null) if 'static-connectors' is defined.")
	private String discoveryGroup;
	@AttributeDocumentation("The number of attempts to connect initially with this cluster connection.")
	private Integer initialConnectAttempts;
	@AttributeDocumentation("The maximum number of times a message can be forwarded. ActiveMQ can be configured to also load balance messages to nodes which might be connected to it only indirectly with other ActiveMQ servers as intermediates in a chain.")
	private Integer maxHops;
	@AttributeDocumentation("The maximum interval of time used to retry connections")
	private Long maxRetryInterval;
	@AttributeDocumentation("The type of message load balancing provided by the cluster connection.")
	private MessageLoadBalancingType messageLoadBalancingType;
	@AttributeDocumentation("The minimum size (in bytes) for a message before it is considered as a large message.")
	private Integer minLargeMessageSize;
	@AttributeDocumentation("The node ID used by this cluster connection.")
	private String nodeId;
	@AttributeDocumentation("How many times the cluster connection will broadcast itself")
	private Integer notificationAttempts;
	@AttributeDocumentation("How often the cluster connection will broadcast itself")
	private Long notificationInterval;
	@AttributeDocumentation("Producer flow control size on the cluster connection.")
	private Integer producerWindowSize;
	@AttributeDocumentation("The total number of reconnect attempts the bridge will make before giving up and shutting down. A value of -1 signifies an unlimited number of attempts.")
	private Integer reconnectAttempts;
	@AttributeDocumentation("The period in milliseconds between subsequent attempts to reconnect to a target server, if the connection to the target server has failed.")
	private Long retryInterval;
	@AttributeDocumentation("A multiplier to apply to the time since the last retry to compute the time to the next retry. This allows you to implement an exponential backoff between retry attempts.")
	private Double retryIntervalMultiplier;
	@AttributeDocumentation("Whether the cluster connection is started.")
	private Boolean started;
	@AttributeDocumentation("The statically defined list of connectors to which this cluster connection will make connections. Must be undefined (null) if 'discovery-group-name' is defined.")
	private List<String> staticConnectors;
	@AttributeDocumentation("The topology of the nodes that this cluster connection is aware of.")
	private String topology;
	@AttributeDocumentation("Whether the bridge will automatically insert a duplicate id property into each message that it forwards.")
	private Boolean useDuplicateDetection;

	public ClusterConnection(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum MessageLoadBalancingType {
		OFF("OFF"), STRICT("STRICT"), ON_DEMAND("ON_DEMAND");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		MessageLoadBalancingType(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Whether, if a node learns of the existence of a node that is more than 1
	 * hop away, we do not create a bridge for direct cluster connection. Only
	 * relevant if 'static-connectors' is defined.
	 */
	@ModelNodeBinding(detypedName = "allow-direct-connections-only")
	public Boolean allowDirectConnectionsOnly() {
		return this.allowDirectConnectionsOnly;
	}

	/**
	 * Whether, if a node learns of the existence of a node that is more than 1
	 * hop away, we do not create a bridge for direct cluster connection. Only
	 * relevant if 'static-connectors' is defined.
	 */
	@SuppressWarnings("unchecked")
	public T allowDirectConnectionsOnly(java.lang.Boolean value) {
		Object oldValue = this.allowDirectConnectionsOnly;
		this.allowDirectConnectionsOnly = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowDirectConnectionsOnly", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The timeout to use when fail over is in process (in ms) for remote calls
	 * made by the cluster connection.
	 */
	@ModelNodeBinding(detypedName = "call-failover-timeout")
	public Long callFailoverTimeout() {
		return this.callFailoverTimeout;
	}

	/**
	 * The timeout to use when fail over is in process (in ms) for remote calls
	 * made by the cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public T callFailoverTimeout(java.lang.Long value) {
		Object oldValue = this.callFailoverTimeout;
		this.callFailoverTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("callFailoverTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The timeout (in ms) for remote calls made by the cluster connection.
	 */
	@ModelNodeBinding(detypedName = "call-timeout")
	public Long callTimeout() {
		return this.callTimeout;
	}

	/**
	 * The timeout (in ms) for remote calls made by the cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public T callTimeout(java.lang.Long value) {
		Object oldValue = this.callTimeout;
		this.callTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("callTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The period (in milliseconds) between client failure check.
	 */
	@ModelNodeBinding(detypedName = "check-period")
	public Long checkPeriod() {
		return this.checkPeriod;
	}

	/**
	 * The period (in milliseconds) between client failure check.
	 */
	@SuppressWarnings("unchecked")
	public T checkPeriod(java.lang.Long value) {
		Object oldValue = this.checkPeriod;
		this.checkPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("checkPeriod", oldValue, value);
		return (T) this;
	}

	/**
	 * Each cluster connection only applies to messages sent to an address that
	 * starts with this value.
	 */
	@ModelNodeBinding(detypedName = "cluster-connection-address")
	public String clusterConnectionAddress() {
		return this.clusterConnectionAddress;
	}

	/**
	 * Each cluster connection only applies to messages sent to an address that
	 * starts with this value.
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnectionAddress(java.lang.String value) {
		Object oldValue = this.clusterConnectionAddress;
		this.clusterConnectionAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clusterConnectionAddress", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The confirmation-window-size to use for the connection used to forward
	 * messages to a target node.
	 */
	@ModelNodeBinding(detypedName = "confirmation-window-size")
	public Integer confirmationWindowSize() {
		return this.confirmationWindowSize;
	}

	/**
	 * The confirmation-window-size to use for the connection used to forward
	 * messages to a target node.
	 */
	@SuppressWarnings("unchecked")
	public T confirmationWindowSize(java.lang.Integer value) {
		Object oldValue = this.confirmationWindowSize;
		this.confirmationWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("confirmationWindowSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum time (in milliseconds) for which the connections used by the
	 * cluster connections are considered alive (in the absence of heartbeat).
	 */
	@ModelNodeBinding(detypedName = "connection-ttl")
	public Long connectionTtl() {
		return this.connectionTtl;
	}

	/**
	 * The maximum time (in milliseconds) for which the connections used by the
	 * cluster connections are considered alive (in the absence of heartbeat).
	 */
	@SuppressWarnings("unchecked")
	public T connectionTtl(java.lang.Long value) {
		Object oldValue = this.connectionTtl;
		this.connectionTtl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionTtl", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of connector to use for live connection
	 */
	@ModelNodeBinding(detypedName = "connector-name")
	public String connectorName() {
		return this.connectorName;
	}

	/**
	 * The name of connector to use for live connection
	 */
	@SuppressWarnings("unchecked")
	public T connectorName(java.lang.String value) {
		Object oldValue = this.connectorName;
		this.connectorName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectorName", oldValue, value);
		return (T) this;
	}

	/**
	 * The discovery group used to obtain the list of other servers in the
	 * cluster to which this cluster connection will make connections. Must be
	 * undefined (null) if 'static-connectors' is defined.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The discovery group used to obtain the list of other servers in the
	 * cluster to which this cluster connection will make connections. Must be
	 * undefined (null) if 'static-connectors' is defined.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(java.lang.String value) {
		Object oldValue = this.discoveryGroup;
		this.discoveryGroup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("discoveryGroup", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of attempts to connect initially with this cluster connection.
	 */
	@ModelNodeBinding(detypedName = "initial-connect-attempts")
	public Integer initialConnectAttempts() {
		return this.initialConnectAttempts;
	}

	/**
	 * The number of attempts to connect initially with this cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public T initialConnectAttempts(java.lang.Integer value) {
		Object oldValue = this.initialConnectAttempts;
		this.initialConnectAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialConnectAttempts", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum number of times a message can be forwarded. ActiveMQ can be
	 * configured to also load balance messages to nodes which might be
	 * connected to it only indirectly with other ActiveMQ servers as
	 * intermediates in a chain.
	 */
	@ModelNodeBinding(detypedName = "max-hops")
	public Integer maxHops() {
		return this.maxHops;
	}

	/**
	 * The maximum number of times a message can be forwarded. ActiveMQ can be
	 * configured to also load balance messages to nodes which might be
	 * connected to it only indirectly with other ActiveMQ servers as
	 * intermediates in a chain.
	 */
	@SuppressWarnings("unchecked")
	public T maxHops(java.lang.Integer value) {
		Object oldValue = this.maxHops;
		this.maxHops = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxHops", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum interval of time used to retry connections
	 */
	@ModelNodeBinding(detypedName = "max-retry-interval")
	public Long maxRetryInterval() {
		return this.maxRetryInterval;
	}

	/**
	 * The maximum interval of time used to retry connections
	 */
	@SuppressWarnings("unchecked")
	public T maxRetryInterval(java.lang.Long value) {
		Object oldValue = this.maxRetryInterval;
		this.maxRetryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxRetryInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * The type of message load balancing provided by the cluster connection.
	 */
	@ModelNodeBinding(detypedName = "message-load-balancing-type")
	public MessageLoadBalancingType messageLoadBalancingType() {
		return this.messageLoadBalancingType;
	}

	/**
	 * The type of message load balancing provided by the cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public T messageLoadBalancingType(MessageLoadBalancingType value) {
		Object oldValue = this.messageLoadBalancingType;
		this.messageLoadBalancingType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageLoadBalancingType", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The minimum size (in bytes) for a message before it is considered as a
	 * large message.
	 */
	@ModelNodeBinding(detypedName = "min-large-message-size")
	public Integer minLargeMessageSize() {
		return this.minLargeMessageSize;
	}

	/**
	 * The minimum size (in bytes) for a message before it is considered as a
	 * large message.
	 */
	@SuppressWarnings("unchecked")
	public T minLargeMessageSize(java.lang.Integer value) {
		Object oldValue = this.minLargeMessageSize;
		this.minLargeMessageSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minLargeMessageSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The node ID used by this cluster connection.
	 */
	@ModelNodeBinding(detypedName = "node-id")
	public String nodeId() {
		return this.nodeId;
	}

	/**
	 * The node ID used by this cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public T nodeId(java.lang.String value) {
		Object oldValue = this.nodeId;
		this.nodeId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nodeId", oldValue, value);
		return (T) this;
	}

	/**
	 * How many times the cluster connection will broadcast itself
	 */
	@ModelNodeBinding(detypedName = "notification-attempts")
	public Integer notificationAttempts() {
		return this.notificationAttempts;
	}

	/**
	 * How many times the cluster connection will broadcast itself
	 */
	@SuppressWarnings("unchecked")
	public T notificationAttempts(java.lang.Integer value) {
		Object oldValue = this.notificationAttempts;
		this.notificationAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("notificationAttempts", oldValue, value);
		return (T) this;
	}

	/**
	 * How often the cluster connection will broadcast itself
	 */
	@ModelNodeBinding(detypedName = "notification-interval")
	public Long notificationInterval() {
		return this.notificationInterval;
	}

	/**
	 * How often the cluster connection will broadcast itself
	 */
	@SuppressWarnings("unchecked")
	public T notificationInterval(java.lang.Long value) {
		Object oldValue = this.notificationInterval;
		this.notificationInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("notificationInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * Producer flow control size on the cluster connection.
	 */
	@ModelNodeBinding(detypedName = "producer-window-size")
	public Integer producerWindowSize() {
		return this.producerWindowSize;
	}

	/**
	 * Producer flow control size on the cluster connection.
	 */
	@SuppressWarnings("unchecked")
	public T producerWindowSize(java.lang.Integer value) {
		Object oldValue = this.producerWindowSize;
		this.producerWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("producerWindowSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The total number of reconnect attempts the bridge will make before giving
	 * up and shutting down. A value of -1 signifies an unlimited number of
	 * attempts.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The total number of reconnect attempts the bridge will make before giving
	 * up and shutting down. A value of -1 signifies an unlimited number of
	 * attempts.
	 */
	@SuppressWarnings("unchecked")
	public T reconnectAttempts(java.lang.Integer value) {
		Object oldValue = this.reconnectAttempts;
		this.reconnectAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reconnectAttempts", oldValue, value);
		return (T) this;
	}

	/**
	 * The period in milliseconds between subsequent attempts to reconnect to a
	 * target server, if the connection to the target server has failed.
	 */
	@ModelNodeBinding(detypedName = "retry-interval")
	public Long retryInterval() {
		return this.retryInterval;
	}

	/**
	 * The period in milliseconds between subsequent attempts to reconnect to a
	 * target server, if the connection to the target server has failed.
	 */
	@SuppressWarnings("unchecked")
	public T retryInterval(java.lang.Long value) {
		Object oldValue = this.retryInterval;
		this.retryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("retryInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * A multiplier to apply to the time since the last retry to compute the
	 * time to the next retry. This allows you to implement an exponential
	 * backoff between retry attempts.
	 */
	@ModelNodeBinding(detypedName = "retry-interval-multiplier")
	public Double retryIntervalMultiplier() {
		return this.retryIntervalMultiplier;
	}

	/**
	 * A multiplier to apply to the time since the last retry to compute the
	 * time to the next retry. This allows you to implement an exponential
	 * backoff between retry attempts.
	 */
	@SuppressWarnings("unchecked")
	public T retryIntervalMultiplier(java.lang.Double value) {
		Object oldValue = this.retryIntervalMultiplier;
		this.retryIntervalMultiplier = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("retryIntervalMultiplier", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Whether the cluster connection is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether the cluster connection is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(java.lang.Boolean value) {
		Object oldValue = this.started;
		this.started = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("started", oldValue, value);
		return (T) this;
	}

	/**
	 * The statically defined list of connectors to which this cluster
	 * connection will make connections. Must be undefined (null) if
	 * 'discovery-group-name' is defined.
	 */
	@ModelNodeBinding(detypedName = "static-connectors")
	public List<String> staticConnectors() {
		return this.staticConnectors;
	}

	/**
	 * The statically defined list of connectors to which this cluster
	 * connection will make connections. Must be undefined (null) if
	 * 'discovery-group-name' is defined.
	 */
	@SuppressWarnings("unchecked")
	public T staticConnectors(java.util.List<String> value) {
		Object oldValue = this.staticConnectors;
		this.staticConnectors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("staticConnectors", oldValue, value);
		return (T) this;
	}

	/**
	 * The statically defined list of connectors to which this cluster
	 * connection will make connections. Must be undefined (null) if
	 * 'discovery-group-name' is defined.
	 */
	@SuppressWarnings("unchecked")
	public T staticConnector(String value) {
		if (this.staticConnectors == null) {
			this.staticConnectors = new java.util.ArrayList<>();
		}
		this.staticConnectors.add(value);
		return (T) this;
	}

	/**
	 * The statically defined list of connectors to which this cluster
	 * connection will make connections. Must be undefined (null) if
	 * 'discovery-group-name' is defined.
	 */
	@SuppressWarnings("unchecked")
	public T staticConnectors(String... args) {
		staticConnectors(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The topology of the nodes that this cluster connection is aware of.
	 */
	@ModelNodeBinding(detypedName = "topology")
	public String topology() {
		return this.topology;
	}

	/**
	 * The topology of the nodes that this cluster connection is aware of.
	 */
	@SuppressWarnings("unchecked")
	public T topology(java.lang.String value) {
		Object oldValue = this.topology;
		this.topology = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("topology", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the bridge will automatically insert a duplicate id property into
	 * each message that it forwards.
	 */
	@ModelNodeBinding(detypedName = "use-duplicate-detection")
	public Boolean useDuplicateDetection() {
		return this.useDuplicateDetection;
	}

	/**
	 * Whether the bridge will automatically insert a duplicate id property into
	 * each message that it forwards.
	 */
	@SuppressWarnings("unchecked")
	public T useDuplicateDetection(java.lang.Boolean value) {
		Object oldValue = this.useDuplicateDetection;
		this.useDuplicateDetection = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useDuplicateDetection", oldValue,
					value);
		return (T) this;
	}
}