package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A connector service allows to integrate external components with Apache
 * ActiveMQ Artemis to send and receive messages.
 */
@Address("/subsystem=messaging-activemq/server=*/connector-service=*")
@ResourceType("connector-service")
public class ConnectorService<T extends ConnectorService<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Class name of the factory class that can instantiate the connector service.")
	private String factoryClass;
	@AttributeDocumentation("A key/value pair understood by the connector service's factory-class")
	private Map params;

	public ConnectorService(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class name of the factory class that can instantiate the connector
	 * service.
	 */
	@ModelNodeBinding(detypedName = "factory-class")
	public String factoryClass() {
		return this.factoryClass;
	}

	/**
	 * Class name of the factory class that can instantiate the connector
	 * service.
	 */
	@SuppressWarnings("unchecked")
	public T factoryClass(java.lang.String value) {
		Object oldValue = this.factoryClass;
		this.factoryClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("factoryClass", oldValue, value);
		return (T) this;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	@SuppressWarnings("unchecked")
	public T params(java.util.Map value) {
		Object oldValue = this.params;
		this.params = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("params", oldValue, value);
		return (T) this;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	@SuppressWarnings("unchecked")
	public T param(java.lang.String key, java.lang.Object value) {
		if (this.params == null) {
			this.params = new java.util.HashMap<>();
		}
		this.params.put(key, value);
		return (T) this;
	}
}