package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ReplicationMasterHAPolicyConsumer<T extends ReplicationMasterHAPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of ReplicationMasterHAPolicy
	 * resource
	 * 
	 * @parameter Instance of ReplicationMasterHAPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default ReplicationMasterHAPolicyConsumer<T> andThen(
			ReplicationMasterHAPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}