package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SharedStoreMasterHAPolicyConsumer<T extends SharedStoreMasterHAPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of SharedStoreMasterHAPolicy
	 * resource
	 * 
	 * @parameter Instance of SharedStoreMasterHAPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default SharedStoreMasterHAPolicyConsumer<T> andThen(
			SharedStoreMasterHAPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}