package org.wildfly.swarm.config.modcluster.proxy;

import org.wildfly.swarm.config.modcluster.proxy.ConfigurationSsl;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConfigurationSslConsumer<T extends ConfigurationSsl<T>> {

	/**
	 * Configure a pre-constructed instance of ConfigurationSsl resource
	 * 
	 * @parameter Instance of ConfigurationSsl to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConfigurationSslConsumer<T> andThen(
			ConfigurationSslConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}