package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModuleSupplier;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Authorization configuration. Configures a list of authorization policy
 * modules to be used.
 */
@Address("/subsystem=security/security-domain=*/authorization=classic")
@ResourceType("authorization")
@Implicit
public class ClassicAuthorization<T extends ClassicAuthorization<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ClassicAuthorizationResources subresources = new ClassicAuthorizationResources();

	public ClassicAuthorization() {
		super();
		this.key = "classic";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ClassicAuthorizationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all PolicyModule objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PolicyModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T policyModules(java.util.List<PolicyModule> value) {
		this.subresources.policyModules = value;
		return (T) this;
	}

	/**
	 * Add the PolicyModule object to the list of subresources
	 * 
	 * @param value
	 *            The PolicyModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T policyModule(PolicyModule value) {
		this.subresources.policyModules.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PolicyModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the PolicyModule resource
	 * @param config
	 *            The PolicyModuleConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T policyModule(java.lang.String childKey,
			PolicyModuleConsumer consumer) {
		PolicyModule<? extends PolicyModule> child = new PolicyModule<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		policyModule(child);
		return (T) this;
	}

	/**
	 * Create and configure a PolicyModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the PolicyModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T policyModule(java.lang.String childKey) {
		policyModule(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PolicyModule object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T policyModule(PolicyModuleSupplier supplier) {
		policyModule(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ClassicAuthorization
	 */
	public static class ClassicAuthorizationResources {
		/**
		 * List of authentication modules
		 */
		@ResourceDocumentation("List of authentication modules")
		@SubresourceInfo("policyModule")
		private List<PolicyModule> policyModules = new java.util.ArrayList<>();

		/**
		 * Get the list of PolicyModule resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PolicyModule> policyModules() {
			return this.policyModules;
		}

		public PolicyModule policyModule(java.lang.String key) {
			return this.policyModules.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}