package org.wildfly.swarm.config.singleton;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.singleton.singleton_policy.ServiceConsumer;
import org.wildfly.swarm.config.singleton.singleton_policy.ServiceSupplier;
import org.wildfly.swarm.config.singleton.singleton_policy.Service;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.singleton.singleton_policy.DeploymentConsumer;
import org.wildfly.swarm.config.singleton.singleton_policy.DeploymentSupplier;
import org.wildfly.swarm.config.singleton.singleton_policy.Deployment;
import org.wildfly.swarm.config.singleton.singleton_policy.RandomElectionPolicy;
import org.wildfly.swarm.config.singleton.singleton_policy.RandomElectionPolicyConsumer;
import org.wildfly.swarm.config.singleton.singleton_policy.RandomElectionPolicySupplier;
import org.wildfly.swarm.config.singleton.singleton_policy.SimpleElectionPolicy;
import org.wildfly.swarm.config.singleton.singleton_policy.SimpleElectionPolicyConsumer;
import org.wildfly.swarm.config.singleton.singleton_policy.SimpleElectionPolicySupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A singleton policy
 */
@Address("/subsystem=singleton/singleton-policy=*")
@ResourceType("singleton-policy")
public class SingletonPolicy<T extends SingletonPolicy<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private SingletonPolicyResources subresources = new SingletonPolicyResources();
	@AttributeDocumentation("The cache backing the singleton policy's singleton service. If undefined, the default cache of the specified cache-container is used.")
	private String cache;
	@AttributeDocumentation("The cache container backing the singleton policy's singleton service")
	private String cacheContainer;
	@AttributeDocumentation("The minimum number of nodes required before this singleton service will start")
	private Integer quorum;

	public SingletonPolicy(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public SingletonPolicyResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Service objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Service objects.
	 */
	@SuppressWarnings("unchecked")
	public T services(java.util.List<Service> value) {
		this.subresources.services = value;
		return (T) this;
	}

	/**
	 * Add the Service object to the list of subresources
	 * 
	 * @param value
	 *            The Service to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T service(Service value) {
		this.subresources.services.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Service object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Service resource
	 * @param config
	 *            The ServiceConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T service(java.lang.String childKey, ServiceConsumer consumer) {
		Service<? extends Service> child = new Service<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		service(child);
		return (T) this;
	}

	/**
	 * Create and configure a Service object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Service resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T service(java.lang.String childKey) {
		service(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Service object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T service(ServiceSupplier supplier) {
		service(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Deployment objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Deployment objects.
	 */
	@SuppressWarnings("unchecked")
	public T deployments(java.util.List<Deployment> value) {
		this.subresources.deployments = value;
		return (T) this;
	}

	/**
	 * Add the Deployment object to the list of subresources
	 * 
	 * @param value
	 *            The Deployment to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T deployment(Deployment value) {
		this.subresources.deployments.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Deployment object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Deployment resource
	 * @param config
	 *            The DeploymentConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T deployment(java.lang.String childKey, DeploymentConsumer consumer) {
		Deployment<? extends Deployment> child = new Deployment<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		deployment(child);
		return (T) this;
	}

	/**
	 * Create and configure a Deployment object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Deployment resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T deployment(java.lang.String childKey) {
		deployment(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Deployment object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T deployment(DeploymentSupplier supplier) {
		deployment(supplier.get());
		return (T) this;
	}

	/**
	 * A random election policy
	 */
	@SuppressWarnings("unchecked")
	public T randomElectionPolicy(RandomElectionPolicy value) {
		this.subresources.randomElectionPolicy = value;
		return (T) this;
	}

	/**
	 * A random election policy
	 */
	@SuppressWarnings("unchecked")
	public T randomElectionPolicy(RandomElectionPolicyConsumer consumer) {
		RandomElectionPolicy<? extends RandomElectionPolicy> child = new RandomElectionPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.randomElectionPolicy = child;
		return (T) this;
	}

	/**
	 * A random election policy
	 */
	@SuppressWarnings("unchecked")
	public T randomElectionPolicy() {
		RandomElectionPolicy<? extends RandomElectionPolicy> child = new RandomElectionPolicy<>();
		this.subresources.randomElectionPolicy = child;
		return (T) this;
	}

	/**
	 * A random election policy
	 */
	@SuppressWarnings("unchecked")
	public T randomElectionPolicy(RandomElectionPolicySupplier supplier) {
		this.subresources.randomElectionPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A simple election policy
	 */
	@SuppressWarnings("unchecked")
	public T simpleElectionPolicy(SimpleElectionPolicy value) {
		this.subresources.simpleElectionPolicy = value;
		return (T) this;
	}

	/**
	 * A simple election policy
	 */
	@SuppressWarnings("unchecked")
	public T simpleElectionPolicy(SimpleElectionPolicyConsumer consumer) {
		SimpleElectionPolicy<? extends SimpleElectionPolicy> child = new SimpleElectionPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.simpleElectionPolicy = child;
		return (T) this;
	}

	/**
	 * A simple election policy
	 */
	@SuppressWarnings("unchecked")
	public T simpleElectionPolicy() {
		SimpleElectionPolicy<? extends SimpleElectionPolicy> child = new SimpleElectionPolicy<>();
		this.subresources.simpleElectionPolicy = child;
		return (T) this;
	}

	/**
	 * A simple election policy
	 */
	@SuppressWarnings("unchecked")
	public T simpleElectionPolicy(SimpleElectionPolicySupplier supplier) {
		this.subresources.simpleElectionPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for SingletonPolicy
	 */
	public static class SingletonPolicyResources {
		/**
		 * A singleton service
		 */
		@ResourceDocumentation("A singleton service")
		@SubresourceInfo("service")
		private List<Service> services = new java.util.ArrayList<>();
		/**
		 * A singleton deployment
		 */
		@ResourceDocumentation("A singleton deployment")
		@SubresourceInfo("deployment")
		private List<Deployment> deployments = new java.util.ArrayList<>();
		@SingletonResource
		@ResourceDocumentation("A random election policy")
		private RandomElectionPolicy randomElectionPolicy;
		@SingletonResource
		@ResourceDocumentation("A simple election policy")
		private SimpleElectionPolicy simpleElectionPolicy;

		/**
		 * Get the list of Service resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Service> services() {
			return this.services;
		}

		public Service service(java.lang.String key) {
			return this.services.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of Deployment resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Deployment> deployments() {
			return this.deployments;
		}

		public Deployment deployment(java.lang.String key) {
			return this.deployments.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * A random election policy
		 */
		@Subresource
		public RandomElectionPolicy randomElectionPolicy() {
			return this.randomElectionPolicy;
		}

		/**
		 * A simple election policy
		 */
		@Subresource
		public SimpleElectionPolicy simpleElectionPolicy() {
			return this.simpleElectionPolicy;
		}
	}

	/**
	 * The cache backing the singleton policy's singleton service. If undefined,
	 * the default cache of the specified cache-container is used.
	 */
	@ModelNodeBinding(detypedName = "cache")
	public String cache() {
		return this.cache;
	}

	/**
	 * The cache backing the singleton policy's singleton service. If undefined,
	 * the default cache of the specified cache-container is used.
	 */
	@SuppressWarnings("unchecked")
	public T cache(java.lang.String value) {
		Object oldValue = this.cache;
		this.cache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cache", oldValue, value);
		return (T) this;
	}

	/**
	 * The cache container backing the singleton policy's singleton service
	 */
	@ModelNodeBinding(detypedName = "cache-container")
	public String cacheContainer() {
		return this.cacheContainer;
	}

	/**
	 * The cache container backing the singleton policy's singleton service
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(java.lang.String value) {
		Object oldValue = this.cacheContainer;
		this.cacheContainer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheContainer", oldValue, value);
		return (T) this;
	}

	/**
	 * The minimum number of nodes required before this singleton service will
	 * start
	 */
	@ModelNodeBinding(detypedName = "quorum")
	public Integer quorum() {
		return this.quorum;
	}

	/**
	 * The minimum number of nodes required before this singleton service will
	 * start
	 */
	@SuppressWarnings("unchecked")
	public T quorum(java.lang.Integer value) {
		Object oldValue = this.quorum;
		this.quorum = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("quorum", oldValue, value);
		return (T) this;
	}
}