package org.wildfly.swarm.config.singleton.singleton_policy;

import org.wildfly.swarm.config.singleton.singleton_policy.Deployment;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface DeploymentConsumer<T extends Deployment<T>> {

	/**
	 * Configure a pre-constructed instance of Deployment resource
	 * 
	 * @parameter Instance of Deployment to configure
	 * @return nothing
	 */
	void accept(T value);

	default DeploymentConsumer<T> andThen(DeploymentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}