package org.wildfly.swarm.config.singleton.singleton_policy;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A singleton service
 */
@Address("/subsystem=singleton/singleton-policy=*/service=*")
@ResourceType("service")
public class Service<T extends Service<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Indicates whether the local member is the primary provider of this singleton service")
	private Boolean isPrimary;
	@AttributeDocumentation("The primary provider of this singleton service")
	private String primaryProvider;
	@AttributeDocumentation("The members on which the singleton service is installed")
	private List<String> providers;

	public Service(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Indicates whether the local member is the primary provider of this
	 * singleton service
	 */
	@ModelNodeBinding(detypedName = "is-primary")
	public Boolean isPrimary() {
		return this.isPrimary;
	}

	/**
	 * Indicates whether the local member is the primary provider of this
	 * singleton service
	 */
	@SuppressWarnings("unchecked")
	public T isPrimary(java.lang.Boolean value) {
		Object oldValue = this.isPrimary;
		this.isPrimary = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("isPrimary", oldValue, value);
		return (T) this;
	}

	/**
	 * The primary provider of this singleton service
	 */
	@ModelNodeBinding(detypedName = "primary-provider")
	public String primaryProvider() {
		return this.primaryProvider;
	}

	/**
	 * The primary provider of this singleton service
	 */
	@SuppressWarnings("unchecked")
	public T primaryProvider(java.lang.String value) {
		Object oldValue = this.primaryProvider;
		this.primaryProvider = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("primaryProvider", oldValue, value);
		return (T) this;
	}

	/**
	 * The members on which the singleton service is installed
	 */
	@ModelNodeBinding(detypedName = "providers")
	public List<String> providers() {
		return this.providers;
	}

	/**
	 * The members on which the singleton service is installed
	 */
	@SuppressWarnings("unchecked")
	public T providers(java.util.List<String> value) {
		Object oldValue = this.providers;
		this.providers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("providers", oldValue, value);
		return (T) this;
	}

	/**
	 * The members on which the singleton service is installed
	 */
	@SuppressWarnings("unchecked")
	public T provider(String value) {
		if (this.providers == null) {
			this.providers = new java.util.ArrayList<>();
		}
		this.providers.add(value);
		return (T) this;
	}

	/**
	 * The members on which the singleton service is installed
	 */
	@SuppressWarnings("unchecked")
	public T providers(String... args) {
		providers(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}