package org.wildfly.swarm.config.singleton.singleton_policy;

import org.wildfly.swarm.config.singleton.singleton_policy.Service;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ServiceConsumer<T extends Service<T>> {

	/**
	 * Configure a pre-constructed instance of Service resource
	 * 
	 * @parameter Instance of Service to configure
	 * @return nothing
	 */
	void accept(T value);

	default ServiceConsumer<T> andThen(ServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}