package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.undertow.ByteBufferPool;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ByteBufferPoolConsumer<T extends ByteBufferPool<T>> {

	/**
	 * Configure a pre-constructed instance of ByteBufferPool resource
	 * 
	 * @parameter Instance of ByteBufferPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default ByteBufferPoolConsumer<T> andThen(ByteBufferPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}